/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a subnet and an IPv6 CIDR block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetIpv6CidrBlockAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SubnetIpv6CidrBlockAssociation.Builder, SubnetIpv6CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(SubnetIpv6CidrBlockAssociation::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("ipv6CidrBlock").build()).build();

    private static final SdkField<SubnetCidrBlockState> IPV6_CIDR_BLOCK_STATE_FIELD = SdkField
            .<SubnetCidrBlockState> builder(MarshallingType.SDK_POJO)
            .memberName("Ipv6CidrBlockState")
            .getter(getter(SubnetIpv6CidrBlockAssociation::ipv6CidrBlockState))
            .setter(setter(Builder::ipv6CidrBlockState))
            .constructor(SubnetCidrBlockState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockState")
                    .unmarshallLocationName("ipv6CidrBlockState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            IPV6_CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String ipv6CidrBlock;

    private final SubnetCidrBlockState ipv6CidrBlockState;

    private SubnetIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */
    public final String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The state of the CIDR block.
     * </p>
     * 
     * @return The state of the CIDR block.
     */
    public final SubnetCidrBlockState ipv6CidrBlockState() {
        return ipv6CidrBlockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpv6CidrBlockAssociation)) {
            return false;
        }
        SubnetIpv6CidrBlockAssociation other = (SubnetIpv6CidrBlockAssociation) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(ipv6CidrBlockState(), other.ipv6CidrBlockState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetIpv6CidrBlockAssociation").add("AssociationId", associationId())
                .add("Ipv6CidrBlock", ipv6CidrBlock()).add("Ipv6CidrBlockState", ipv6CidrBlockState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "Ipv6CidrBlockState":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetIpv6CidrBlockAssociation, T> g) {
        return obj -> g.apply((SubnetIpv6CidrBlockAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetIpv6CidrBlockAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param associationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlockState
         *        The state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState);

        /**
         * <p>
         * The state of the CIDR block.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubnetCidrBlockState.Builder} avoiding
         * the need to create one manually via {@link SubnetCidrBlockState#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubnetCidrBlockState.Builder#build()} is called immediately and
         * its result is passed to {@link #ipv6CidrBlockState(SubnetCidrBlockState)}.
         * 
         * @param ipv6CidrBlockState
         *        a consumer that will call methods on {@link SubnetCidrBlockState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockState(SubnetCidrBlockState)
         */
        default Builder ipv6CidrBlockState(Consumer<SubnetCidrBlockState.Builder> ipv6CidrBlockState) {
            return ipv6CidrBlockState(SubnetCidrBlockState.builder().applyMutation(ipv6CidrBlockState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String ipv6CidrBlock;

        private SubnetCidrBlockState ipv6CidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpv6CidrBlockAssociation model) {
            associationId(model.associationId);
            ipv6CidrBlock(model.ipv6CidrBlock);
            ipv6CidrBlockState(model.ipv6CidrBlockState);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final SubnetCidrBlockState.Builder getIpv6CidrBlockState() {
            return ipv6CidrBlockState != null ? ipv6CidrBlockState.toBuilder() : null;
        }

        public final void setIpv6CidrBlockState(SubnetCidrBlockState.BuilderImpl ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState != null ? ipv6CidrBlockState.build() : null;
        }

        @Override
        public final Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        @Override
        public SubnetIpv6CidrBlockAssociation build() {
            return new SubnetIpv6CidrBlockAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
