/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcPeeringConnectionOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcPeeringConnectionOptionsRequest.Builder, ModifyVpcPeeringConnectionOptionsRequest> {
    private static final SdkField<PeeringConnectionOptionsRequest> ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField
            .<PeeringConnectionOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("AccepterPeeringConnectionOptions")
            .getter(getter(ModifyVpcPeeringConnectionOptionsRequest::accepterPeeringConnectionOptions))
            .setter(setter(Builder::accepterPeeringConnectionOptions))
            .constructor(PeeringConnectionOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterPeeringConnectionOptions")
                    .unmarshallLocationName("AccepterPeeringConnectionOptions").build()).build();

    private static final SdkField<PeeringConnectionOptionsRequest> REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField
            .<PeeringConnectionOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("RequesterPeeringConnectionOptions")
            .getter(getter(ModifyVpcPeeringConnectionOptionsRequest::requesterPeeringConnectionOptions))
            .setter(setter(Builder::requesterPeeringConnectionOptions))
            .constructor(PeeringConnectionOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPeeringConnectionOptions")
                    .unmarshallLocationName("RequesterPeeringConnectionOptions").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId")
            .getter(getter(ModifyVpcPeeringConnectionOptionsRequest::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId")
                    .unmarshallLocationName("VpcPeeringConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD, REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD,
            VPC_PEERING_CONNECTION_ID_FIELD));

    private final PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

    private final PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

    private final String vpcPeeringConnectionId;

    private ModifyVpcPeeringConnectionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The VPC peering connection options for the accepter VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the accepter VPC.
     */
    public final PeeringConnectionOptionsRequest accepterPeeringConnectionOptions() {
        return accepterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The VPC peering connection options for the requester VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the requester VPC.
     */
    public final PeeringConnectionOptionsRequest requesterPeeringConnectionOptions() {
        return requesterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accepterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsRequest other = (ModifyVpcPeeringConnectionOptionsRequest) obj;
        return Objects.equals(accepterPeeringConnectionOptions(), other.accepterPeeringConnectionOptions())
                && Objects.equals(requesterPeeringConnectionOptions(), other.requesterPeeringConnectionOptions())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcPeeringConnectionOptionsRequest")
                .add("AccepterPeeringConnectionOptions", accepterPeeringConnectionOptions())
                .add("RequesterPeeringConnectionOptions", requesterPeeringConnectionOptions())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterPeeringConnectionOptions":
            return Optional.ofNullable(clazz.cast(accepterPeeringConnectionOptions()));
        case "RequesterPeeringConnectionOptions":
            return Optional.ofNullable(clazz.cast(requesterPeeringConnectionOptions()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcPeeringConnectionOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcPeeringConnectionOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsRequest> {
        /**
         * <p>
         * The VPC peering connection options for the accepter VPC.
         * </p>
         * 
         * @param accepterPeeringConnectionOptions
         *        The VPC peering connection options for the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions);

        /**
         * <p>
         * The VPC peering connection options for the accepter VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeeringConnectionOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link PeeringConnectionOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest)}.
         * 
         * @param accepterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest)
         */
        default Builder accepterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptionsRequest.Builder> accepterPeeringConnectionOptions) {
            return accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest.builder()
                    .applyMutation(accepterPeeringConnectionOptions).build());
        }

        /**
         * <p>
         * The VPC peering connection options for the requester VPC.
         * </p>
         * 
         * @param requesterPeeringConnectionOptions
         *        The VPC peering connection options for the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions);

        /**
         * <p>
         * The VPC peering connection options for the requester VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link PeeringConnectionOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link PeeringConnectionOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest)}.
         * 
         * @param requesterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest)
         */
        default Builder requesterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptionsRequest.Builder> requesterPeeringConnectionOptions) {
            return requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest.builder()
                    .applyMutation(requesterPeeringConnectionOptions).build());
        }

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

        private PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsRequest model) {
            super(model);
            accepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            requesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final PeeringConnectionOptionsRequest.Builder getAccepterPeeringConnectionOptions() {
            return accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions.toBuilder() : null;
        }

        public final void setAccepterPeeringConnectionOptions(
                PeeringConnectionOptionsRequest.BuilderImpl accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions
                    .build() : null;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final PeeringConnectionOptionsRequest.Builder getRequesterPeeringConnectionOptions() {
            return requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions.toBuilder() : null;
        }

        public final void setRequesterPeeringConnectionOptions(
                PeeringConnectionOptionsRequest.BuilderImpl requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions
                    .build() : null;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsRequest build() {
            return new ModifyVpcPeeringConnectionOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
