/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagesInRecycleBinResponse extends Ec2Response implements
        ToCopyableBuilder<ListImagesInRecycleBinResponse.Builder, ListImagesInRecycleBinResponse> {
    private static final SdkField<List<ImageRecycleBinInfo>> IMAGES_FIELD = SdkField
            .<List<ImageRecycleBinInfo>> builder(MarshallingType.LIST)
            .memberName("Images")
            .getter(getter(ListImagesInRecycleBinResponse::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSet")
                    .unmarshallLocationName("imageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageRecycleBinInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageRecycleBinInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListImagesInRecycleBinResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ImageRecycleBinInfo> images;

    private final String nextToken;

    private ListImagesInRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Images property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the AMIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImages} method.
     * </p>
     * 
     * @return Information about the AMIs.
     */
    public final List<ImageRecycleBinInfo> images() {
        return images;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesInRecycleBinResponse)) {
            return false;
        }
        ListImagesInRecycleBinResponse other = (ListImagesInRecycleBinResponse) obj;
        return hasImages() == other.hasImages() && Objects.equals(images(), other.images())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImagesInRecycleBinResponse").add("Images", hasImages() ? images() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesInRecycleBinResponse, T> g) {
        return obj -> g.apply((ListImagesInRecycleBinResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListImagesInRecycleBinResponse> {
        /**
         * <p>
         * Information about the AMIs.
         * </p>
         * 
         * @param images
         *        Information about the AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<ImageRecycleBinInfo> images);

        /**
         * <p>
         * Information about the AMIs.
         * </p>
         * 
         * @param images
         *        Information about the AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(ImageRecycleBinInfo... images);

        /**
         * <p>
         * Information about the AMIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ImageRecycleBinInfo>.Builder}
         * avoiding the need to create one manually via {@link List<ImageRecycleBinInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageRecycleBinInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #images(List<ImageRecycleBinInfo>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<ImageRecycleBinInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<ImageRecycleBinInfo>)
         */
        Builder images(Consumer<ImageRecycleBinInfo.Builder>... images);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ImageRecycleBinInfo> images = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesInRecycleBinResponse model) {
            super(model);
            images(model.images);
            nextToken(model.nextToken);
        }

        public final List<ImageRecycleBinInfo.Builder> getImages() {
            List<ImageRecycleBinInfo.Builder> result = ImageRecycleBinInfoListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<ImageRecycleBinInfo.BuilderImpl> images) {
            this.images = ImageRecycleBinInfoListCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<ImageRecycleBinInfo> images) {
            this.images = ImageRecycleBinInfoListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(ImageRecycleBinInfo... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<ImageRecycleBinInfo.Builder>... images) {
            images(Stream.of(images).map(c -> ImageRecycleBinInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImagesInRecycleBinResponse build() {
            return new ListImagesInRecycleBinResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
