/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CIDR provisioned to an IPAM pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPoolCidr implements SdkPojo, Serializable, ToCopyableBuilder<IpamPoolCidr.Builder, IpamPoolCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(IpamPoolCidr::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(IpamPoolCidr::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<IpamPoolCidrFailureReason> FAILURE_REASON_FIELD = SdkField
            .<IpamPoolCidrFailureReason> builder(MarshallingType.SDK_POJO)
            .memberName("FailureReason")
            .getter(getter(IpamPoolCidr::failureReason))
            .setter(setter(Builder::failureReason))
            .constructor(IpamPoolCidrFailureReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason")
                    .unmarshallLocationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, STATE_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String state;

    private final IpamPoolCidrFailureReason failureReason;

    private IpamPoolCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.state = builder.state;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network
     * mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>. An
     * IPv6 CIDR example is <code>2001:DB8::/32</code>.
     * </p>
     * 
     * @return The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated
     *         network mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is
     *         <code>10.24.34.0/23</code>. An IPv6 CIDR example is <code>2001:DB8::/32</code>.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The state of the CIDR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamPoolCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the CIDR.
     * @see IpamPoolCidrState
     */
    public final IpamPoolCidrState state() {
        return IpamPoolCidrState.fromValue(state);
    }

    /**
     * <p>
     * The state of the CIDR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IpamPoolCidrState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the CIDR.
     * @see IpamPoolCidrState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Details related to why an IPAM pool CIDR failed to be provisioned.
     * </p>
     * 
     * @return Details related to why an IPAM pool CIDR failed to be provisioned.
     */
    public final IpamPoolCidrFailureReason failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolCidr)) {
            return false;
        }
        IpamPoolCidr other = (IpamPoolCidr) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPoolCidr").add("Cidr", cidr()).add("State", stateAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolCidr, T> g) {
        return obj -> g.apply((IpamPoolCidr) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPoolCidr> {
        /**
         * <p>
         * The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network
         * mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>.
         * An IPv6 CIDR example is <code>2001:DB8::/32</code>.
         * </p>
         * 
         * @param cidr
         *        The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated
         *        network mask (or netmask) and refers to a range of IP addresses. An IPv4 CIDR example is
         *        <code>10.24.34.0/23</code>. An IPv6 CIDR example is <code>2001:DB8::/32</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The state of the CIDR.
         * </p>
         * 
         * @param state
         *        The state of the CIDR.
         * @see IpamPoolCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolCidrState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the CIDR.
         * </p>
         * 
         * @param state
         *        The state of the CIDR.
         * @see IpamPoolCidrState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPoolCidrState
         */
        Builder state(IpamPoolCidrState state);

        /**
         * <p>
         * Details related to why an IPAM pool CIDR failed to be provisioned.
         * </p>
         * 
         * @param failureReason
         *        Details related to why an IPAM pool CIDR failed to be provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(IpamPoolCidrFailureReason failureReason);

        /**
         * <p>
         * Details related to why an IPAM pool CIDR failed to be provisioned.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPoolCidrFailureReason.Builder}
         * avoiding the need to create one manually via {@link IpamPoolCidrFailureReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpamPoolCidrFailureReason.Builder#build()} is called immediately
         * and its result is passed to {@link #failureReason(IpamPoolCidrFailureReason)}.
         * 
         * @param failureReason
         *        a consumer that will call methods on {@link IpamPoolCidrFailureReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureReason(IpamPoolCidrFailureReason)
         */
        default Builder failureReason(Consumer<IpamPoolCidrFailureReason.Builder> failureReason) {
            return failureReason(IpamPoolCidrFailureReason.builder().applyMutation(failureReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String state;

        private IpamPoolCidrFailureReason failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolCidr model) {
            cidr(model.cidr);
            state(model.state);
            failureReason(model.failureReason);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPoolCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final IpamPoolCidrFailureReason.Builder getFailureReason() {
            return failureReason != null ? failureReason.toBuilder() : null;
        }

        public final void setFailureReason(IpamPoolCidrFailureReason.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(IpamPoolCidrFailureReason failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public IpamPoolCidr build() {
            return new IpamPoolCidr(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
