/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the FPGAs for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FpgaInfo implements SdkPojo, Serializable, ToCopyableBuilder<FpgaInfo.Builder, FpgaInfo> {
    private static final SdkField<List<FpgaDeviceInfo>> FPGAS_FIELD = SdkField
            .<List<FpgaDeviceInfo>> builder(MarshallingType.LIST)
            .memberName("Fpgas")
            .getter(getter(FpgaInfo::fpgas))
            .setter(setter(Builder::fpgas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fpgas")
                    .unmarshallLocationName("fpgas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FpgaDeviceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FpgaDeviceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TOTAL_FPGA_MEMORY_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFpgaMemoryInMiB")
            .getter(getter(FpgaInfo::totalFpgaMemoryInMiB))
            .setter(setter(Builder::totalFpgaMemoryInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFpgaMemoryInMiB")
                    .unmarshallLocationName("totalFpgaMemoryInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGAS_FIELD,
            TOTAL_FPGA_MEMORY_IN_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FpgaDeviceInfo> fpgas;

    private final Integer totalFpgaMemoryInMiB;

    private FpgaInfo(BuilderImpl builder) {
        this.fpgas = builder.fpgas;
        this.totalFpgaMemoryInMiB = builder.totalFpgaMemoryInMiB;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fpgas property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFpgas() {
        return fpgas != null && !(fpgas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the FPGAs for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFpgas} method.
     * </p>
     * 
     * @return Describes the FPGAs for the instance type.
     */
    public final List<FpgaDeviceInfo> fpgas() {
        return fpgas;
    }

    /**
     * <p>
     * The total memory of all FPGA accelerators for the instance type.
     * </p>
     * 
     * @return The total memory of all FPGA accelerators for the instance type.
     */
    public final Integer totalFpgaMemoryInMiB() {
        return totalFpgaMemoryInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFpgas() ? fpgas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalFpgaMemoryInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaInfo)) {
            return false;
        }
        FpgaInfo other = (FpgaInfo) obj;
        return hasFpgas() == other.hasFpgas() && Objects.equals(fpgas(), other.fpgas())
                && Objects.equals(totalFpgaMemoryInMiB(), other.totalFpgaMemoryInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FpgaInfo").add("Fpgas", hasFpgas() ? fpgas() : null)
                .add("TotalFpgaMemoryInMiB", totalFpgaMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fpgas":
            return Optional.ofNullable(clazz.cast(fpgas()));
        case "TotalFpgaMemoryInMiB":
            return Optional.ofNullable(clazz.cast(totalFpgaMemoryInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaInfo, T> g) {
        return obj -> g.apply((FpgaInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FpgaInfo> {
        /**
         * <p>
         * Describes the FPGAs for the instance type.
         * </p>
         * 
         * @param fpgas
         *        Describes the FPGAs for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgas(Collection<FpgaDeviceInfo> fpgas);

        /**
         * <p>
         * Describes the FPGAs for the instance type.
         * </p>
         * 
         * @param fpgas
         *        Describes the FPGAs for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgas(FpgaDeviceInfo... fpgas);

        /**
         * <p>
         * Describes the FPGAs for the instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FpgaDeviceInfo>.Builder} avoiding
         * the need to create one manually via {@link List<FpgaDeviceInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FpgaDeviceInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #fpgas(List<FpgaDeviceInfo>)}.
         * 
         * @param fpgas
         *        a consumer that will call methods on {@link List<FpgaDeviceInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fpgas(List<FpgaDeviceInfo>)
         */
        Builder fpgas(Consumer<FpgaDeviceInfo.Builder>... fpgas);

        /**
         * <p>
         * The total memory of all FPGA accelerators for the instance type.
         * </p>
         * 
         * @param totalFpgaMemoryInMiB
         *        The total memory of all FPGA accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB);
    }

    static final class BuilderImpl implements Builder {
        private List<FpgaDeviceInfo> fpgas = DefaultSdkAutoConstructList.getInstance();

        private Integer totalFpgaMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaInfo model) {
            fpgas(model.fpgas);
            totalFpgaMemoryInMiB(model.totalFpgaMemoryInMiB);
        }

        public final List<FpgaDeviceInfo.Builder> getFpgas() {
            List<FpgaDeviceInfo.Builder> result = FpgaDeviceInfoListCopier.copyToBuilder(this.fpgas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFpgas(Collection<FpgaDeviceInfo.BuilderImpl> fpgas) {
            this.fpgas = FpgaDeviceInfoListCopier.copyFromBuilder(fpgas);
        }

        @Override
        public final Builder fpgas(Collection<FpgaDeviceInfo> fpgas) {
            this.fpgas = FpgaDeviceInfoListCopier.copy(fpgas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgas(FpgaDeviceInfo... fpgas) {
            fpgas(Arrays.asList(fpgas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgas(Consumer<FpgaDeviceInfo.Builder>... fpgas) {
            fpgas(Stream.of(fpgas).map(c -> FpgaDeviceInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalFpgaMemoryInMiB() {
            return totalFpgaMemoryInMiB;
        }

        public final void setTotalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
            this.totalFpgaMemoryInMiB = totalFpgaMemoryInMiB;
        }

        @Override
        public final Builder totalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
            this.totalFpgaMemoryInMiB = totalFpgaMemoryInMiB;
            return this;
        }

        @Override
        public FpgaInfo build() {
            return new FpgaInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
