/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachVolumeRequest extends Ec2Request implements
        ToCopyableBuilder<DetachVolumeRequest.Builder, DetachVolumeRequest> {
    private static final SdkField<String> DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Device")
            .getter(getter(DetachVolumeRequest::device))
            .setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device")
                    .unmarshallLocationName("Device").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Force")
            .getter(getter(DetachVolumeRequest::force))
            .setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force")
                    .unmarshallLocationName("Force").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(DetachVolumeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(DetachVolumeRequest::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD, FORCE_FIELD,
            INSTANCE_ID_FIELD, VOLUME_ID_FIELD));

    private final String device;

    private final Boolean force;

    private final String instanceId;

    private final String volumeId;

    private DetachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.device = builder.device;
        this.force = builder.force;
        this.instanceId = builder.instanceId;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public final String device() {
        return device;
    }

    /**
     * <p>
     * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file
     * system. Use this option only as a last resort to detach a volume from a failed instance. The instance won't have
     * an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file
     * system check and repair procedures.
     * </p>
     * 
     * @return Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     *         instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
     *         corrupted file system. Use this option only as a last resort to detach a volume from a failed instance.
     *         The instance won't have an opportunity to flush file system caches or file system metadata. If you use
     *         this option, you must perform file system check and repair procedures.
     */
    public final Boolean force() {
        return force;
    }

    /**
     * <p>
     * The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an instance ID.
     * </p>
     * 
     * @return The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an instance
     *         ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest) obj;
        return Objects.equals(device(), other.device()) && Objects.equals(force(), other.force())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(volumeId(), other.volumeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachVolumeRequest").add("Device", device()).add("Force", force())
                .add("InstanceId", instanceId()).add("VolumeId", volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachVolumeRequest, T> g) {
        return obj -> g.apply((DetachVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DetachVolumeRequest> {
        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
         * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted
         * file system. Use this option only as a last resort to detach a volume from a failed instance. The instance
         * won't have an opportunity to flush file system caches or file system metadata. If you use this option, you
         * must perform file system check and repair procedures.
         * </p>
         * 
         * @param force
         *        Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into
         *        an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
         *        corrupted file system. Use this option only as a last resort to detach a volume from a failed
         *        instance. The instance won't have an opportunity to flush file system caches or file system metadata.
         *        If you use this option, you must perform file system check and repair procedures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an instance ID.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an
         *        instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String device;

        private Boolean force;

        private String instanceId;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            super(model);
            device(model.device);
            force(model.force);
            instanceId(model.instanceId);
            volumeId(model.volumeId);
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
