/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchTemplateVersionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateLaunchTemplateVersionResponse.Builder, CreateLaunchTemplateVersionResponse> {
    private static final SdkField<LaunchTemplateVersion> LAUNCH_TEMPLATE_VERSION_FIELD = SdkField
            .<LaunchTemplateVersion> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateVersion")
            .getter(getter(CreateLaunchTemplateVersionResponse::launchTemplateVersion))
            .setter(setter(Builder::launchTemplateVersion))
            .constructor(LaunchTemplateVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion")
                    .unmarshallLocationName("launchTemplateVersion").build()).build();

    private static final SdkField<ValidationWarning> WARNING_FIELD = SdkField
            .<ValidationWarning> builder(MarshallingType.SDK_POJO)
            .memberName("Warning")
            .getter(getter(CreateLaunchTemplateVersionResponse::warning))
            .setter(setter(Builder::warning))
            .constructor(ValidationWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning")
                    .unmarshallLocationName("warning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_VERSION_FIELD,
            WARNING_FIELD));

    private final LaunchTemplateVersion launchTemplateVersion;

    private final ValidationWarning warning;

    private CreateLaunchTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersion = builder.launchTemplateVersion;
        this.warning = builder.warning;
    }

    /**
     * <p>
     * Information about the launch template version.
     * </p>
     * 
     * @return Information about the launch template version.
     */
    public final LaunchTemplateVersion launchTemplateVersion() {
        return launchTemplateVersion;
    }

    /**
     * <p>
     * If the new version of the launch template contains parameters or parameter combinations that are not valid, an
     * error code and an error message are returned for each issue that's found.
     * </p>
     * 
     * @return If the new version of the launch template contains parameters or parameter combinations that are not
     *         valid, an error code and an error message are returned for each issue that's found.
     */
    public final ValidationWarning warning() {
        return warning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateVersion());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionResponse)) {
            return false;
        }
        CreateLaunchTemplateVersionResponse other = (CreateLaunchTemplateVersionResponse) obj;
        return Objects.equals(launchTemplateVersion(), other.launchTemplateVersion())
                && Objects.equals(warning(), other.warning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLaunchTemplateVersionResponse").add("LaunchTemplateVersion", launchTemplateVersion())
                .add("Warning", warning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateVersion":
            return Optional.ofNullable(clazz.cast(launchTemplateVersion()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
        /**
         * <p>
         * Information about the launch template version.
         * </p>
         * 
         * @param launchTemplateVersion
         *        Information about the launch template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion);

        /**
         * <p>
         * Information about the launch template version.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateVersion.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #launchTemplateVersion(LaunchTemplateVersion)}.
         * 
         * @param launchTemplateVersion
         *        a consumer that will call methods on {@link LaunchTemplateVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateVersion(LaunchTemplateVersion)
         */
        default Builder launchTemplateVersion(Consumer<LaunchTemplateVersion.Builder> launchTemplateVersion) {
            return launchTemplateVersion(LaunchTemplateVersion.builder().applyMutation(launchTemplateVersion).build());
        }

        /**
         * <p>
         * If the new version of the launch template contains parameters or parameter combinations that are not valid,
         * an error code and an error message are returned for each issue that's found.
         * </p>
         * 
         * @param warning
         *        If the new version of the launch template contains parameters or parameter combinations that are not
         *        valid, an error code and an error message are returned for each issue that's found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(ValidationWarning warning);

        /**
         * <p>
         * If the new version of the launch template contains parameters or parameter combinations that are not valid,
         * an error code and an error message are returned for each issue that's found.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationWarning.Builder} avoiding the
         * need to create one manually via {@link ValidationWarning#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValidationWarning.Builder#build()} is called immediately and its
         * result is passed to {@link #warning(ValidationWarning)}.
         * 
         * @param warning
         *        a consumer that will call methods on {@link ValidationWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warning(ValidationWarning)
         */
        default Builder warning(Consumer<ValidationWarning.Builder> warning) {
            return warning(ValidationWarning.builder().applyMutation(warning).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LaunchTemplateVersion launchTemplateVersion;

        private ValidationWarning warning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionResponse model) {
            super(model);
            launchTemplateVersion(model.launchTemplateVersion);
            warning(model.warning);
        }

        public final LaunchTemplateVersion.Builder getLaunchTemplateVersion() {
            return launchTemplateVersion != null ? launchTemplateVersion.toBuilder() : null;
        }

        public final void setLaunchTemplateVersion(LaunchTemplateVersion.BuilderImpl launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion != null ? launchTemplateVersion.build() : null;
        }

        @Override
        public final Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
            return this;
        }

        public final ValidationWarning.Builder getWarning() {
            return warning != null ? warning.toBuilder() : null;
        }

        public final void setWarning(ValidationWarning.BuilderImpl warning) {
            this.warning = warning != null ? warning.build() : null;
        }

        @Override
        public final Builder warning(ValidationWarning warning) {
            this.warning = warning;
            return this;
        }

        @Override
        public CreateLaunchTemplateVersionResponse build() {
            return new CreateLaunchTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
