/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTrunkInterfaceResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateTrunkInterfaceResponse.Builder, AssociateTrunkInterfaceResponse> {
    private static final SdkField<TrunkInterfaceAssociation> INTERFACE_ASSOCIATION_FIELD = SdkField
            .<TrunkInterfaceAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("InterfaceAssociation")
            .getter(getter(AssociateTrunkInterfaceResponse::interfaceAssociation))
            .setter(setter(Builder::interfaceAssociation))
            .constructor(TrunkInterfaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceAssociation")
                    .unmarshallLocationName("interfaceAssociation").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AssociateTrunkInterfaceResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_ASSOCIATION_FIELD,
            CLIENT_TOKEN_FIELD));

    private final TrunkInterfaceAssociation interfaceAssociation;

    private final String clientToken;

    private AssociateTrunkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.interfaceAssociation = builder.interfaceAssociation;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the association between the trunk network interface and branch network interface.
     * </p>
     * 
     * @return Information about the association between the trunk network interface and branch network interface.
     */
    public final TrunkInterfaceAssociation interfaceAssociation() {
        return interfaceAssociation;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to Ensure Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTrunkInterfaceResponse)) {
            return false;
        }
        AssociateTrunkInterfaceResponse other = (AssociateTrunkInterfaceResponse) obj;
        return Objects.equals(interfaceAssociation(), other.interfaceAssociation())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateTrunkInterfaceResponse").add("InterfaceAssociation", interfaceAssociation())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterfaceAssociation":
            return Optional.ofNullable(clazz.cast(interfaceAssociation()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTrunkInterfaceResponse, T> g) {
        return obj -> g.apply((AssociateTrunkInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AssociateTrunkInterfaceResponse> {
        /**
         * <p>
         * Information about the association between the trunk network interface and branch network interface.
         * </p>
         * 
         * @param interfaceAssociation
         *        Information about the association between the trunk network interface and branch network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssociation(TrunkInterfaceAssociation interfaceAssociation);

        /**
         * <p>
         * Information about the association between the trunk network interface and branch network interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrunkInterfaceAssociation.Builder}
         * avoiding the need to create one manually via {@link TrunkInterfaceAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrunkInterfaceAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #interfaceAssociation(TrunkInterfaceAssociation)}.
         * 
         * @param interfaceAssociation
         *        a consumer that will call methods on {@link TrunkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceAssociation(TrunkInterfaceAssociation)
         */
        default Builder interfaceAssociation(Consumer<TrunkInterfaceAssociation.Builder> interfaceAssociation) {
            return interfaceAssociation(TrunkInterfaceAssociation.builder().applyMutation(interfaceAssociation).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrunkInterfaceAssociation interfaceAssociation;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTrunkInterfaceResponse model) {
            super(model);
            interfaceAssociation(model.interfaceAssociation);
            clientToken(model.clientToken);
        }

        public final TrunkInterfaceAssociation.Builder getInterfaceAssociation() {
            return interfaceAssociation != null ? interfaceAssociation.toBuilder() : null;
        }

        public final void setInterfaceAssociation(TrunkInterfaceAssociation.BuilderImpl interfaceAssociation) {
            this.interfaceAssociation = interfaceAssociation != null ? interfaceAssociation.build() : null;
        }

        @Override
        public final Builder interfaceAssociation(TrunkInterfaceAssociation interfaceAssociation) {
            this.interfaceAssociation = interfaceAssociation;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public AssociateTrunkInterfaceResponse build() {
            return new AssociateTrunkInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
