/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Protocol;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInsightsPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInsightsPath> {
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsPathId").getter(NetworkInsightsPath.getter(NetworkInsightsPath::networkInsightsPathId)).setter(NetworkInsightsPath.setter(Builder::networkInsightsPathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId").unmarshallLocationName("networkInsightsPathId").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsPathArn").getter(NetworkInsightsPath.getter(NetworkInsightsPath::networkInsightsPathArn)).setter(NetworkInsightsPath.setter(Builder::networkInsightsPathArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathArn").unmarshallLocationName("networkInsightsPathArn").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(NetworkInsightsPath.getter(NetworkInsightsPath::createdDate)).setter(NetworkInsightsPath.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").unmarshallLocationName("createdDate").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(NetworkInsightsPath.getter(NetworkInsightsPath::source)).setter(NetworkInsightsPath.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("source").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(NetworkInsightsPath.getter(NetworkInsightsPath::destination)).setter(NetworkInsightsPath.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("destination").build()}).build();
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIp").getter(NetworkInsightsPath.getter(NetworkInsightsPath::sourceIp)).setter(NetworkInsightsPath.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").unmarshallLocationName("sourceIp").build()}).build();
    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIp").getter(NetworkInsightsPath.getter(NetworkInsightsPath::destinationIp)).setter(NetworkInsightsPath.setter(Builder::destinationIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIp").unmarshallLocationName("destinationIp").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(NetworkInsightsPath.getter(NetworkInsightsPath::protocolAsString)).setter(NetworkInsightsPath.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DestinationPort").getter(NetworkInsightsPath.getter(NetworkInsightsPath::destinationPort)).setter(NetworkInsightsPath.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").unmarshallLocationName("destinationPort").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NetworkInsightsPath.getter(NetworkInsightsPath::tags)).setter(NetworkInsightsPath.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_PATH_ID_FIELD, NETWORK_INSIGHTS_PATH_ARN_FIELD, CREATED_DATE_FIELD, SOURCE_FIELD, DESTINATION_FIELD, SOURCE_IP_FIELD, DESTINATION_IP_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkInsightsPathId;
    private final String networkInsightsPathArn;
    private final Instant createdDate;
    private final String source;
    private final String destination;
    private final String sourceIp;
    private final String destinationIp;
    private final String protocol;
    private final Integer destinationPort;
    private final List<Tag> tags;

    private NetworkInsightsPath(BuilderImpl builder) {
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.networkInsightsPathArn = builder.networkInsightsPathArn;
        this.createdDate = builder.createdDate;
        this.source = builder.source;
        this.destination = builder.destination;
        this.sourceIp = builder.sourceIp;
        this.destinationIp = builder.destinationIp;
        this.protocol = builder.protocol;
        this.destinationPort = builder.destinationPort;
        this.tags = builder.tags;
    }

    public final String networkInsightsPathId() {
        return this.networkInsightsPathId;
    }

    public final String networkInsightsPathArn() {
        return this.networkInsightsPathArn;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String source() {
        return this.source;
    }

    public final String destination() {
        return this.destination;
    }

    public final String sourceIp() {
        return this.sourceIp;
    }

    public final String destinationIp() {
        return this.destinationIp;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsPath)) {
            return false;
        }
        NetworkInsightsPath other = (NetworkInsightsPath)obj;
        return Objects.equals(this.networkInsightsPathId(), other.networkInsightsPathId()) && Objects.equals(this.networkInsightsPathArn(), other.networkInsightsPathArn()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.sourceIp(), other.sourceIp()) && Objects.equals(this.destinationIp(), other.destinationIp()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.destinationPort(), other.destinationPort()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInsightsPath").add("NetworkInsightsPathId", (Object)this.networkInsightsPathId()).add("NetworkInsightsPathArn", (Object)this.networkInsightsPathArn()).add("CreatedDate", (Object)this.createdDate()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("SourceIp", (Object)this.sourceIp()).add("DestinationIp", (Object)this.destinationIp()).add("Protocol", (Object)this.protocolAsString()).add("DestinationPort", (Object)this.destinationPort()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsPathId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsPathId()));
            }
            case "NetworkInsightsPathArn": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsPathArn()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIp()));
            }
            case "DestinationIp": {
                return Optional.ofNullable(clazz.cast(this.destinationIp()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsPath, T> g) {
        return obj -> g.apply((NetworkInsightsPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsPathId;
        private String networkInsightsPathArn;
        private Instant createdDate;
        private String source;
        private String destination;
        private String sourceIp;
        private String destinationIp;
        private String protocol;
        private Integer destinationPort;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsPath model) {
            this.networkInsightsPathId(model.networkInsightsPathId);
            this.networkInsightsPathArn(model.networkInsightsPathArn);
            this.createdDate(model.createdDate);
            this.source(model.source);
            this.destination(model.destination);
            this.sourceIp(model.sourceIp);
            this.destinationIp(model.destinationIp);
            this.protocol(model.protocol);
            this.destinationPort(model.destinationPort);
            this.tags(model.tags);
        }

        public final String getNetworkInsightsPathId() {
            return this.networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final String getNetworkInsightsPathArn() {
            return this.networkInsightsPathArn;
        }

        public final void setNetworkInsightsPathArn(String networkInsightsPathArn) {
            this.networkInsightsPathArn = networkInsightsPathArn;
        }

        @Override
        public final Builder networkInsightsPathArn(String networkInsightsPathArn) {
            this.networkInsightsPathArn = networkInsightsPathArn;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getDestinationIp() {
            return this.destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkInsightsPath build() {
            return new NetworkInsightsPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInsightsPath> {
        public Builder networkInsightsPathId(String var1);

        public Builder networkInsightsPathArn(String var1);

        public Builder createdDate(Instant var1);

        public Builder source(String var1);

        public Builder destination(String var1);

        public Builder sourceIp(String var1);

        public Builder destinationIp(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder destinationPort(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

