/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a Spot Instance request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotInstanceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotInstanceStatus.Builder, SpotInstanceStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Code")
            .getter(getter(SpotInstanceStatus::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Message")
            .getter(getter(SpotInstanceStatus::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("message").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(SpotInstanceStatus::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime")
                    .unmarshallLocationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final Instant updateTime;

    private SpotInstanceStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The status code. For a list of status codes, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand"
     * >Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The status code. For a list of status codes, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand"
     *         >Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The description for the status code.
     * </p>
     * 
     * @return The description for the status code.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The date and time of the most recent status update, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time of the most recent status update, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceStatus)) {
            return false;
        }
        SpotInstanceStatus other = (SpotInstanceStatus) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotInstanceStatus").add("Code", code()).add("Message", message())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotInstanceStatus, T> g) {
        return obj -> g.apply((SpotInstanceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotInstanceStatus> {
        /**
         * <p>
         * The status code. For a list of status codes, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand"
         * >Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param code
         *        The status code. For a list of status codes, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand"
         *        >Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The description for the status code.
         * </p>
         * 
         * @param message
         *        The description for the status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The date and time of the most recent status update, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param updateTime
         *        The date and time of the most recent status update, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceStatus model) {
            code(model.code);
            message(model.message);
            updateTime(model.updateTime);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public SpotInstanceStatus build() {
            return new SpotInstanceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
