/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTransitGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteTransitGatewayResponse.Builder, DeleteTransitGatewayResponse> {
    private static final SdkField<TransitGateway> TRANSIT_GATEWAY_FIELD = SdkField
            .<TransitGateway> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGateway")
            .getter(getter(DeleteTransitGatewayResponse::transitGateway))
            .setter(setter(Builder::transitGateway))
            .constructor(TransitGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGateway")
                    .unmarshallLocationName("transitGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_FIELD));

    private final TransitGateway transitGateway;

    private DeleteTransitGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.transitGateway = builder.transitGateway;
    }

    /**
     * <p>
     * Information about the deleted transit gateway.
     * </p>
     * 
     * @return Information about the deleted transit gateway.
     */
    public final TransitGateway transitGateway() {
        return transitGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTransitGatewayResponse)) {
            return false;
        }
        DeleteTransitGatewayResponse other = (DeleteTransitGatewayResponse) obj;
        return Objects.equals(transitGateway(), other.transitGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTransitGatewayResponse").add("TransitGateway", transitGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGateway":
            return Optional.ofNullable(clazz.cast(transitGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTransitGatewayResponse, T> g) {
        return obj -> g.apply((DeleteTransitGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTransitGatewayResponse> {
        /**
         * <p>
         * Information about the deleted transit gateway.
         * </p>
         * 
         * @param transitGateway
         *        Information about the deleted transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGateway(TransitGateway transitGateway);

        /**
         * <p>
         * Information about the deleted transit gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGateway.Builder} avoiding the need
         * to create one manually via {@link TransitGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #transitGateway(TransitGateway)}.
         * 
         * @param transitGateway
         *        a consumer that will call methods on {@link TransitGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGateway(TransitGateway)
         */
        default Builder transitGateway(Consumer<TransitGateway.Builder> transitGateway) {
            return transitGateway(TransitGateway.builder().applyMutation(transitGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGateway transitGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTransitGatewayResponse model) {
            super(model);
            transitGateway(model.transitGateway);
        }

        public final TransitGateway.Builder getTransitGateway() {
            return transitGateway != null ? transitGateway.toBuilder() : null;
        }

        public final void setTransitGateway(TransitGateway.BuilderImpl transitGateway) {
            this.transitGateway = transitGateway != null ? transitGateway.build() : null;
        }

        @Override
        public final Builder transitGateway(TransitGateway transitGateway) {
            this.transitGateway = transitGateway;
            return this;
        }

        @Override
        public DeleteTransitGatewayResponse build() {
            return new DeleteTransitGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
