/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlacementGroupResponse extends Ec2Response implements
        ToCopyableBuilder<CreatePlacementGroupResponse.Builder, CreatePlacementGroupResponse> {
    private static final SdkField<PlacementGroup> PLACEMENT_GROUP_FIELD = SdkField
            .<PlacementGroup> builder(MarshallingType.SDK_POJO)
            .memberName("PlacementGroup")
            .getter(getter(CreatePlacementGroupResponse::placementGroup))
            .setter(setter(Builder::placementGroup))
            .constructor(PlacementGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup")
                    .unmarshallLocationName("placementGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_GROUP_FIELD));

    private final PlacementGroup placementGroup;

    private CreatePlacementGroupResponse(BuilderImpl builder) {
        super(builder);
        this.placementGroup = builder.placementGroup;
    }

    /**
     * Returns the value of the PlacementGroup property for this object.
     * 
     * @return The value of the PlacementGroup property for this object.
     */
    public final PlacementGroup placementGroup() {
        return placementGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupResponse)) {
            return false;
        }
        CreatePlacementGroupResponse other = (CreatePlacementGroupResponse) obj;
        return Objects.equals(placementGroup(), other.placementGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlacementGroupResponse").add("PlacementGroup", placementGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlacementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupResponse, T> g) {
        return obj -> g.apply((CreatePlacementGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlacementGroupResponse> {
        /**
         * Sets the value of the PlacementGroup property for this object.
         *
         * @param placementGroup
         *        The new value for the PlacementGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(PlacementGroup placementGroup);

        /**
         * Sets the value of the PlacementGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PlacementGroup.Builder} avoiding the need
         * to create one manually via {@link PlacementGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #placementGroup(PlacementGroup)}.
         * 
         * @param placementGroup
         *        a consumer that will call methods on {@link PlacementGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementGroup(PlacementGroup)
         */
        default Builder placementGroup(Consumer<PlacementGroup.Builder> placementGroup) {
            return placementGroup(PlacementGroup.builder().applyMutation(placementGroup).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private PlacementGroup placementGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupResponse model) {
            super(model);
            placementGroup(model.placementGroup);
        }

        public final PlacementGroup.Builder getPlacementGroup() {
            return placementGroup != null ? placementGroup.toBuilder() : null;
        }

        public final void setPlacementGroup(PlacementGroup.BuilderImpl placementGroup) {
            this.placementGroup = placementGroup != null ? placementGroup.build() : null;
        }

        @Override
        public final Builder placementGroup(PlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        @Override
        public CreatePlacementGroupResponse build() {
            return new CreatePlacementGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
