/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a prefix list reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPrefixListReference implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPrefixListReference.Builder, TransitGatewayPrefixListReference> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableId")
            .getter(getter(TransitGatewayPrefixListReference::transitGatewayRouteTableId))
            .setter(setter(Builder::transitGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId")
                    .unmarshallLocationName("transitGatewayRouteTableId").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(TransitGatewayPrefixListReference::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> PREFIX_LIST_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListOwnerId")
            .getter(getter(TransitGatewayPrefixListReference::prefixListOwnerId))
            .setter(setter(Builder::prefixListOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListOwnerId")
                    .unmarshallLocationName("prefixListOwnerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayPrefixListReference::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Boolean> BLACKHOLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blackhole")
            .getter(getter(TransitGatewayPrefixListReference::blackhole))
            .setter(setter(Builder::blackhole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blackhole")
                    .unmarshallLocationName("blackhole").build()).build();

    private static final SdkField<TransitGatewayPrefixListAttachment> TRANSIT_GATEWAY_ATTACHMENT_FIELD = SdkField
            .<TransitGatewayPrefixListAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayAttachment")
            .getter(getter(TransitGatewayPrefixListReference::transitGatewayAttachment))
            .setter(setter(Builder::transitGatewayAttachment))
            .constructor(TransitGatewayPrefixListAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachment")
                    .unmarshallLocationName("transitGatewayAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_OWNER_ID_FIELD, STATE_FIELD, BLACKHOLE_FIELD,
            TRANSIT_GATEWAY_ATTACHMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayRouteTableId;

    private final String prefixListId;

    private final String prefixListOwnerId;

    private final String state;

    private final Boolean blackhole;

    private final TransitGatewayPrefixListAttachment transitGatewayAttachment;

    private TransitGatewayPrefixListReference(BuilderImpl builder) {
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.prefixListId = builder.prefixListId;
        this.prefixListOwnerId = builder.prefixListOwnerId;
        this.state = builder.state;
        this.blackhole = builder.blackhole;
        this.transitGatewayAttachment = builder.transitGatewayAttachment;
    }

    /**
     * <p>
     * The ID of the transit gateway route table.
     * </p>
     * 
     * @return The ID of the transit gateway route table.
     */
    public final String transitGatewayRouteTableId() {
        return transitGatewayRouteTableId;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The ID of the prefix list owner.
     * </p>
     * 
     * @return The ID of the prefix list owner.
     */
    public final String prefixListOwnerId() {
        return prefixListOwnerId;
    }

    /**
     * <p>
     * The state of the prefix list reference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPrefixListReferenceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the prefix list reference.
     * @see TransitGatewayPrefixListReferenceState
     */
    public final TransitGatewayPrefixListReferenceState state() {
        return TransitGatewayPrefixListReferenceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the prefix list reference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayPrefixListReferenceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the prefix list reference.
     * @see TransitGatewayPrefixListReferenceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Indicates whether traffic that matches this route is dropped.
     * </p>
     * 
     * @return Indicates whether traffic that matches this route is dropped.
     */
    public final Boolean blackhole() {
        return blackhole;
    }

    /**
     * <p>
     * Information about the transit gateway attachment.
     * </p>
     * 
     * @return Information about the transit gateway attachment.
     */
    public final TransitGatewayPrefixListAttachment transitGatewayAttachment() {
        return transitGatewayAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blackhole());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPrefixListReference)) {
            return false;
        }
        TransitGatewayPrefixListReference other = (TransitGatewayPrefixListReference) obj;
        return Objects.equals(transitGatewayRouteTableId(), other.transitGatewayRouteTableId())
                && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(prefixListOwnerId(), other.prefixListOwnerId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(blackhole(), other.blackhole())
                && Objects.equals(transitGatewayAttachment(), other.transitGatewayAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPrefixListReference")
                .add("TransitGatewayRouteTableId", transitGatewayRouteTableId()).add("PrefixListId", prefixListId())
                .add("PrefixListOwnerId", prefixListOwnerId()).add("State", stateAsString()).add("Blackhole", blackhole())
                .add("TransitGatewayAttachment", transitGatewayAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableId()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "PrefixListOwnerId":
            return Optional.ofNullable(clazz.cast(prefixListOwnerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Blackhole":
            return Optional.ofNullable(clazz.cast(blackhole()));
        case "TransitGatewayAttachment":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPrefixListReference, T> g) {
        return obj -> g.apply((TransitGatewayPrefixListReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPrefixListReference> {
        /**
         * <p>
         * The ID of the transit gateway route table.
         * </p>
         * 
         * @param transitGatewayRouteTableId
         *        The ID of the transit gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableId(String transitGatewayRouteTableId);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The ID of the prefix list owner.
         * </p>
         * 
         * @param prefixListOwnerId
         *        The ID of the prefix list owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListOwnerId(String prefixListOwnerId);

        /**
         * <p>
         * The state of the prefix list reference.
         * </p>
         * 
         * @param state
         *        The state of the prefix list reference.
         * @see TransitGatewayPrefixListReferenceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPrefixListReferenceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the prefix list reference.
         * </p>
         * 
         * @param state
         *        The state of the prefix list reference.
         * @see TransitGatewayPrefixListReferenceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayPrefixListReferenceState
         */
        Builder state(TransitGatewayPrefixListReferenceState state);

        /**
         * <p>
         * Indicates whether traffic that matches this route is dropped.
         * </p>
         * 
         * @param blackhole
         *        Indicates whether traffic that matches this route is dropped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackhole(Boolean blackhole);

        /**
         * <p>
         * Information about the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachment
         *        Information about the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachment(TransitGatewayPrefixListAttachment transitGatewayAttachment);

        /**
         * <p>
         * Information about the transit gateway attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayPrefixListAttachment.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayPrefixListAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayPrefixListAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayAttachment(TransitGatewayPrefixListAttachment)}
         * .
         * 
         * @param transitGatewayAttachment
         *        a consumer that will call methods on {@link TransitGatewayPrefixListAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayAttachment(TransitGatewayPrefixListAttachment)
         */
        default Builder transitGatewayAttachment(Consumer<TransitGatewayPrefixListAttachment.Builder> transitGatewayAttachment) {
            return transitGatewayAttachment(TransitGatewayPrefixListAttachment.builder().applyMutation(transitGatewayAttachment)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayRouteTableId;

        private String prefixListId;

        private String prefixListOwnerId;

        private String state;

        private Boolean blackhole;

        private TransitGatewayPrefixListAttachment transitGatewayAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPrefixListReference model) {
            transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            prefixListId(model.prefixListId);
            prefixListOwnerId(model.prefixListOwnerId);
            state(model.state);
            blackhole(model.blackhole);
            transitGatewayAttachment(model.transitGatewayAttachment);
        }

        public final String getTransitGatewayRouteTableId() {
            return transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListOwnerId() {
            return prefixListOwnerId;
        }

        public final void setPrefixListOwnerId(String prefixListOwnerId) {
            this.prefixListOwnerId = prefixListOwnerId;
        }

        @Override
        public final Builder prefixListOwnerId(String prefixListOwnerId) {
            this.prefixListOwnerId = prefixListOwnerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayPrefixListReferenceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getBlackhole() {
            return blackhole;
        }

        public final void setBlackhole(Boolean blackhole) {
            this.blackhole = blackhole;
        }

        @Override
        public final Builder blackhole(Boolean blackhole) {
            this.blackhole = blackhole;
            return this;
        }

        public final TransitGatewayPrefixListAttachment.Builder getTransitGatewayAttachment() {
            return transitGatewayAttachment != null ? transitGatewayAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayAttachment(TransitGatewayPrefixListAttachment.BuilderImpl transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment != null ? transitGatewayAttachment.build() : null;
        }

        @Override
        public final Builder transitGatewayAttachment(TransitGatewayPrefixListAttachment transitGatewayAttachment) {
            this.transitGatewayAttachment = transitGatewayAttachment;
            return this;
        }

        @Override
        public TransitGatewayPrefixListReference build() {
            return new TransitGatewayPrefixListReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
