/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total value of the new Convertible Reserved Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetReservationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetReservationValue.Builder, TargetReservationValue> {
    private static final SdkField<ReservationValue> RESERVATION_VALUE_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .memberName("ReservationValue")
            .getter(getter(TargetReservationValue::reservationValue))
            .setter(setter(Builder::reservationValue))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationValue")
                    .unmarshallLocationName("reservationValue").build()).build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TargetConfiguration")
            .getter(getter(TargetReservationValue::targetConfiguration))
            .setter(setter(Builder::targetConfiguration))
            .constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration")
                    .unmarshallLocationName("targetConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_VALUE_FIELD,
            TARGET_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReservationValue reservationValue;

    private final TargetConfiguration targetConfiguration;

    private TargetReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list
     * value, remaining upfront price, and additional upfront cost of the exchange.
     * </p>
     * 
     * @return The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the
     *         list value, remaining upfront price, and additional upfront cost of the exchange.
     */
    public final ReservationValue reservationValue() {
        return reservationValue;
    }

    /**
     * <p>
     * The configuration of the Convertible Reserved Instances that make up the exchange.
     * </p>
     * 
     * @return The configuration of the Convertible Reserved Instances that make up the exchange.
     */
    public final TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservationValue());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetReservationValue)) {
            return false;
        }
        TargetReservationValue other = (TargetReservationValue) obj;
        return Objects.equals(reservationValue(), other.reservationValue())
                && Objects.equals(targetConfiguration(), other.targetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetReservationValue").add("ReservationValue", reservationValue())
                .add("TargetConfiguration", targetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationValue":
            return Optional.ofNullable(clazz.cast(reservationValue()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetReservationValue, T> g) {
        return obj -> g.apply((TargetReservationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetReservationValue> {
        /**
         * <p>
         * The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list
         * value, remaining upfront price, and additional upfront cost of the exchange.
         * </p>
         * 
         * @param reservationValue
         *        The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of
         *        the list value, remaining upfront price, and additional upfront cost of the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationValue(ReservationValue reservationValue);

        /**
         * <p>
         * The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list
         * value, remaining upfront price, and additional upfront cost of the exchange.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationValue.Builder} avoiding the
         * need to create one manually via {@link ReservationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #reservationValue(ReservationValue)}.
         * 
         * @param reservationValue
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationValue(ReservationValue)
         */
        default Builder reservationValue(Consumer<ReservationValue.Builder> reservationValue) {
            return reservationValue(ReservationValue.builder().applyMutation(reservationValue).build());
        }

        /**
         * <p>
         * The configuration of the Convertible Reserved Instances that make up the exchange.
         * </p>
         * 
         * @param targetConfiguration
         *        The configuration of the Convertible Reserved Instances that make up the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * <p>
         * The configuration of the Convertible Reserved Instances that make up the exchange.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetConfiguration.Builder} avoiding the
         * need to create one manually via {@link TargetConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReservationValue reservationValue;

        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetReservationValue model) {
            reservationValue(model.reservationValue);
            targetConfiguration(model.targetConfiguration);
        }

        public final ReservationValue.Builder getReservationValue() {
            return reservationValue != null ? reservationValue.toBuilder() : null;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        @Override
        public TargetReservationValue build() {
            return new TargetReservationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
