/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data feed for a Spot Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotDatafeedSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotDatafeedSubscription.Builder, SpotDatafeedSubscription> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(SpotDatafeedSubscription::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("bucket").build()).build();

    private static final SdkField<SpotInstanceStateFault> FAULT_FIELD = SdkField
            .<SpotInstanceStateFault> builder(MarshallingType.SDK_POJO)
            .memberName("Fault")
            .getter(getter(SpotDatafeedSubscription::fault))
            .setter(setter(Builder::fault))
            .constructor(SpotInstanceStateFault::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fault")
                    .unmarshallLocationName("fault").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(SpotDatafeedSubscription::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(SpotDatafeedSubscription::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("prefix").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(SpotDatafeedSubscription::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, FAULT_FIELD,
            OWNER_ID_FIELD, PREFIX_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final SpotInstanceStateFault fault;

    private final String ownerId;

    private final String prefix;

    private final String state;

    private SpotDatafeedSubscription(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.fault = builder.fault;
        this.ownerId = builder.ownerId;
        this.prefix = builder.prefix;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the Spot Instance data feed is located.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the Spot Instance data feed is located.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The fault codes for the Spot Instance request, if any.
     * </p>
     * 
     * @return The fault codes for the Spot Instance request, if any.
     */
    public final SpotInstanceStateFault fault() {
        return fault;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the account.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The prefix for the data feed files.
     * </p>
     * 
     * @return The prefix for the data feed files.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The state of the Spot Instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot Instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public final DatafeedSubscriptionState state() {
        return DatafeedSubscriptionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Spot Instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot Instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(fault());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotDatafeedSubscription)) {
            return false;
        }
        SpotDatafeedSubscription other = (SpotDatafeedSubscription) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(fault(), other.fault())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotDatafeedSubscription").add("Bucket", bucket()).add("Fault", fault())
                .add("OwnerId", ownerId()).add("Prefix", prefix()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Fault":
            return Optional.ofNullable(clazz.cast(fault()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotDatafeedSubscription, T> g) {
        return obj -> g.apply((SpotDatafeedSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotDatafeedSubscription> {
        /**
         * <p>
         * The name of the Amazon S3 bucket where the Spot Instance data feed is located.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket where the Spot Instance data feed is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The fault codes for the Spot Instance request, if any.
         * </p>
         * 
         * @param fault
         *        The fault codes for the Spot Instance request, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fault(SpotInstanceStateFault fault);

        /**
         * <p>
         * The fault codes for the Spot Instance request, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotInstanceStateFault.Builder} avoiding
         * the need to create one manually via {@link SpotInstanceStateFault#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotInstanceStateFault.Builder#build()} is called immediately and
         * its result is passed to {@link #fault(SpotInstanceStateFault)}.
         * 
         * @param fault
         *        a consumer that will call methods on {@link SpotInstanceStateFault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fault(SpotInstanceStateFault)
         */
        default Builder fault(Consumer<SpotInstanceStateFault.Builder> fault) {
            return fault(SpotInstanceStateFault.builder().applyMutation(fault).build());
        }

        /**
         * <p>
         * The Amazon Web Services account ID of the account.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The prefix for the data feed files.
         * </p>
         * 
         * @param prefix
         *        The prefix for the data feed files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The state of the Spot Instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot Instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Spot Instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot Instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(DatafeedSubscriptionState state);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private SpotInstanceStateFault fault;

        private String ownerId;

        private String prefix;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotDatafeedSubscription model) {
            bucket(model.bucket);
            fault(model.fault);
            ownerId(model.ownerId);
            prefix(model.prefix);
            state(model.state);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return fault != null ? fault.toBuilder() : null;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatafeedSubscriptionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public SpotDatafeedSubscription build() {
            return new SpotDatafeedSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
