/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceCreditSpecificationResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceCreditSpecificationResponse.Builder, ModifyInstanceCreditSpecificationResponse> {
    private static final SdkField<List<SuccessfulInstanceCreditSpecificationItem>> SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField
            .<List<SuccessfulInstanceCreditSpecificationItem>> builder(MarshallingType.LIST)
            .memberName("SuccessfulInstanceCreditSpecifications")
            .getter(getter(ModifyInstanceCreditSpecificationResponse::successfulInstanceCreditSpecifications))
            .setter(setter(Builder::successfulInstanceCreditSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SuccessfulInstanceCreditSpecificationSet")
                    .unmarshallLocationName("successfulInstanceCreditSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SuccessfulInstanceCreditSpecificationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulInstanceCreditSpecificationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<UnsuccessfulInstanceCreditSpecificationItem>> UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField
            .<List<UnsuccessfulInstanceCreditSpecificationItem>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulInstanceCreditSpecifications")
            .getter(getter(ModifyInstanceCreditSpecificationResponse::unsuccessfulInstanceCreditSpecifications))
            .setter(setter(Builder::unsuccessfulInstanceCreditSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UnsuccessfulInstanceCreditSpecificationSet")
                    .unmarshallLocationName("unsuccessfulInstanceCreditSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulInstanceCreditSpecificationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulInstanceCreditSpecificationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD, UNSUCCESSFUL_INSTANCE_CREDIT_SPECIFICATIONS_FIELD));

    private final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications;

    private final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationResponse(BuilderImpl builder) {
        super(builder);
        this.successfulInstanceCreditSpecifications = builder.successfulInstanceCreditSpecifications;
        this.unsuccessfulInstanceCreditSpecifications = builder.unsuccessfulInstanceCreditSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulInstanceCreditSpecifications
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSuccessfulInstanceCreditSpecifications() {
        return successfulInstanceCreditSpecifications != null
                && !(successfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances whose credit option for CPU usage was successfully modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulInstanceCreditSpecifications}
     * method.
     * </p>
     * 
     * @return Information about the instances whose credit option for CPU usage was successfully modified.
     */
    public final List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications() {
        return successfulInstanceCreditSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsuccessfulInstanceCreditSpecifications
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasUnsuccessfulInstanceCreditSpecifications() {
        return unsuccessfulInstanceCreditSpecifications != null
                && !(unsuccessfulInstanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances whose credit option for CPU usage was not modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasUnsuccessfulInstanceCreditSpecifications} method.
     * </p>
     * 
     * @return Information about the instances whose credit option for CPU usage was not modified.
     */
    public final List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications() {
        return unsuccessfulInstanceCreditSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSuccessfulInstanceCreditSpecifications() ? successfulInstanceCreditSpecifications() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasUnsuccessfulInstanceCreditSpecifications() ? unsuccessfulInstanceCreditSpecifications()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationResponse)) {
            return false;
        }
        ModifyInstanceCreditSpecificationResponse other = (ModifyInstanceCreditSpecificationResponse) obj;
        return hasSuccessfulInstanceCreditSpecifications() == other.hasSuccessfulInstanceCreditSpecifications()
                && Objects.equals(successfulInstanceCreditSpecifications(), other.successfulInstanceCreditSpecifications())
                && hasUnsuccessfulInstanceCreditSpecifications() == other.hasUnsuccessfulInstanceCreditSpecifications()
                && Objects.equals(unsuccessfulInstanceCreditSpecifications(), other.unsuccessfulInstanceCreditSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ModifyInstanceCreditSpecificationResponse")
                .add("SuccessfulInstanceCreditSpecifications",
                        hasSuccessfulInstanceCreditSpecifications() ? successfulInstanceCreditSpecifications() : null)
                .add("UnsuccessfulInstanceCreditSpecifications",
                        hasUnsuccessfulInstanceCreditSpecifications() ? unsuccessfulInstanceCreditSpecifications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulInstanceCreditSpecifications":
            return Optional.ofNullable(clazz.cast(successfulInstanceCreditSpecifications()));
        case "UnsuccessfulInstanceCreditSpecifications":
            return Optional.ofNullable(clazz.cast(unsuccessfulInstanceCreditSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCreditSpecificationResponse, T> g) {
        return obj -> g.apply((ModifyInstanceCreditSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceCreditSpecificationResponse> {
        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * 
         * @param successfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * 
         * @param successfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulInstanceCreditSpecifications(
                SuccessfulInstanceCreditSpecificationItem... successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was successfully modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <SuccessfulInstanceCreditSpecificationItem>.Builder} avoiding the need to create one manually via
         * {@link List<SuccessfulInstanceCreditSpecificationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SuccessfulInstanceCreditSpecificationItem>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfulInstanceCreditSpecifications(List<SuccessfulInstanceCreditSpecificationItem>)}.
         * 
         * @param successfulInstanceCreditSpecifications
         *        a consumer that will call methods on {@link List<SuccessfulInstanceCreditSpecificationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulInstanceCreditSpecifications(List<SuccessfulInstanceCreditSpecificationItem>)
         */
        Builder successfulInstanceCreditSpecifications(
                Consumer<SuccessfulInstanceCreditSpecificationItem.Builder>... successfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was not modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        Information about the instances whose credit option for CPU usage was not modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                UnsuccessfulInstanceCreditSpecificationItem... unsuccessfulInstanceCreditSpecifications);

        /**
         * <p>
         * Information about the instances whose credit option for CPU usage was not modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <UnsuccessfulInstanceCreditSpecificationItem>.Builder} avoiding the need to create one manually via
         * {@link List<UnsuccessfulInstanceCreditSpecificationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <UnsuccessfulInstanceCreditSpecificationItem>.Builder#build()} is called immediately and its result is passed
         * to {@link #unsuccessfulInstanceCreditSpecifications(List<UnsuccessfulInstanceCreditSpecificationItem>)}.
         * 
         * @param unsuccessfulInstanceCreditSpecifications
         *        a consumer that will call methods on {@link List<UnsuccessfulInstanceCreditSpecificationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulInstanceCreditSpecifications(List<UnsuccessfulInstanceCreditSpecificationItem>)
         */
        Builder unsuccessfulInstanceCreditSpecifications(
                Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder>... unsuccessfulInstanceCreditSpecifications);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications = DefaultSdkAutoConstructList
                .getInstance();

        private List<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationResponse model) {
            super(model);
            successfulInstanceCreditSpecifications(model.successfulInstanceCreditSpecifications);
            unsuccessfulInstanceCreditSpecifications(model.unsuccessfulInstanceCreditSpecifications);
        }

        public final List<SuccessfulInstanceCreditSpecificationItem.Builder> getSuccessfulInstanceCreditSpecifications() {
            List<SuccessfulInstanceCreditSpecificationItem.Builder> result = SuccessfulInstanceCreditSpecificationSetCopier
                    .copyToBuilder(this.successfulInstanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem.BuilderImpl> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier
                    .copyFromBuilder(successfulInstanceCreditSpecifications);
        }

        @Override
        public final Builder successfulInstanceCreditSpecifications(
                Collection<SuccessfulInstanceCreditSpecificationItem> successfulInstanceCreditSpecifications) {
            this.successfulInstanceCreditSpecifications = SuccessfulInstanceCreditSpecificationSetCopier
                    .copy(successfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(
                SuccessfulInstanceCreditSpecificationItem... successfulInstanceCreditSpecifications) {
            successfulInstanceCreditSpecifications(Arrays.asList(successfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulInstanceCreditSpecifications(
                Consumer<SuccessfulInstanceCreditSpecificationItem.Builder>... successfulInstanceCreditSpecifications) {
            successfulInstanceCreditSpecifications(Stream.of(successfulInstanceCreditSpecifications)
                    .map(c -> SuccessfulInstanceCreditSpecificationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulInstanceCreditSpecificationItem.Builder> getUnsuccessfulInstanceCreditSpecifications() {
            List<UnsuccessfulInstanceCreditSpecificationItem.Builder> result = UnsuccessfulInstanceCreditSpecificationSetCopier
                    .copyToBuilder(this.unsuccessfulInstanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem.BuilderImpl> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier
                    .copyFromBuilder(unsuccessfulInstanceCreditSpecifications);
        }

        @Override
        public final Builder unsuccessfulInstanceCreditSpecifications(
                Collection<UnsuccessfulInstanceCreditSpecificationItem> unsuccessfulInstanceCreditSpecifications) {
            this.unsuccessfulInstanceCreditSpecifications = UnsuccessfulInstanceCreditSpecificationSetCopier
                    .copy(unsuccessfulInstanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(
                UnsuccessfulInstanceCreditSpecificationItem... unsuccessfulInstanceCreditSpecifications) {
            unsuccessfulInstanceCreditSpecifications(Arrays.asList(unsuccessfulInstanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulInstanceCreditSpecifications(
                Consumer<UnsuccessfulInstanceCreditSpecificationItem.Builder>... unsuccessfulInstanceCreditSpecifications) {
            unsuccessfulInstanceCreditSpecifications(Stream.of(unsuccessfulInstanceCreditSpecifications)
                    .map(c -> UnsuccessfulInstanceCreditSpecificationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyInstanceCreditSpecificationResponse build() {
            return new ModifyInstanceCreditSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
