/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcPeeringConnectionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcPeeringConnectionsResponse.Builder, DescribeVpcPeeringConnectionsResponse> {
    private static final SdkField<List<VpcPeeringConnection>> VPC_PEERING_CONNECTIONS_FIELD = SdkField
            .<List<VpcPeeringConnection>> builder(MarshallingType.LIST)
            .memberName("VpcPeeringConnections")
            .getter(getter(DescribeVpcPeeringConnectionsResponse::vpcPeeringConnections))
            .setter(setter(Builder::vpcPeeringConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionSet")
                    .unmarshallLocationName("vpcPeeringConnectionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VpcPeeringConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcPeeringConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVpcPeeringConnectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_PEERING_CONNECTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VpcPeeringConnection> vpcPeeringConnections;

    private final String nextToken;

    private DescribeVpcPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnections = builder.vpcPeeringConnections;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcPeeringConnections property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcPeeringConnections() {
        return vpcPeeringConnections != null && !(vpcPeeringConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the VPC peering connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcPeeringConnections} method.
     * </p>
     * 
     * @return Information about the VPC peering connections.
     */
    public final List<VpcPeeringConnection> vpcPeeringConnections() {
        return vpcPeeringConnections;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcPeeringConnections() ? vpcPeeringConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsResponse)) {
            return false;
        }
        DescribeVpcPeeringConnectionsResponse other = (DescribeVpcPeeringConnectionsResponse) obj;
        return hasVpcPeeringConnections() == other.hasVpcPeeringConnections()
                && Objects.equals(vpcPeeringConnections(), other.vpcPeeringConnections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcPeeringConnectionsResponse")
                .add("VpcPeeringConnections", hasVpcPeeringConnections() ? vpcPeeringConnections() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnections":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnections()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcPeeringConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcPeeringConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
        /**
         * <p>
         * Information about the VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        Information about the VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections);

        /**
         * <p>
         * Information about the VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        Information about the VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections);

        /**
         * <p>
         * Information about the VPC peering connections.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VpcPeeringConnection>.Builder}
         * avoiding the need to create one manually via {@link List<VpcPeeringConnection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcPeeringConnection>.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcPeeringConnections(List<VpcPeeringConnection>)}.
         * 
         * @param vpcPeeringConnections
         *        a consumer that will call methods on {@link List<VpcPeeringConnection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringConnections(List<VpcPeeringConnection>)
         */
        Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder>... vpcPeeringConnections);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<VpcPeeringConnection> vpcPeeringConnections = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsResponse model) {
            super(model);
            vpcPeeringConnections(model.vpcPeeringConnections);
            nextToken(model.nextToken);
        }

        public final List<VpcPeeringConnection.Builder> getVpcPeeringConnections() {
            List<VpcPeeringConnection.Builder> result = VpcPeeringConnectionListCopier.copyToBuilder(this.vpcPeeringConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcPeeringConnections(Collection<VpcPeeringConnection.BuilderImpl> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copyFromBuilder(vpcPeeringConnections);
        }

        @Override
        public final Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections) {
            vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(Consumer<VpcPeeringConnection.Builder>... vpcPeeringConnections) {
            vpcPeeringConnections(Stream.of(vpcPeeringConnections)
                    .map(c -> VpcPeeringConnection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcPeeringConnectionsResponse build() {
            return new DescribeVpcPeeringConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
