/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeReservedInstancesListings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesListingsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeReservedInstancesListingsResponse.Builder, DescribeReservedInstancesListingsResponse> {
    private static final SdkField<List<ReservedInstancesListing>> RESERVED_INSTANCES_LISTINGS_FIELD = SdkField
            .<List<ReservedInstancesListing>> builder(MarshallingType.LIST)
            .memberName("ReservedInstancesListings")
            .getter(getter(DescribeReservedInstancesListingsResponse::reservedInstancesListings))
            .setter(setter(Builder::reservedInstancesListings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingsSet")
                    .unmarshallLocationName("reservedInstancesListingsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesListing> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesListing::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESERVED_INSTANCES_LISTINGS_FIELD));

    private final List<ReservedInstancesListing> reservedInstancesListings;

    private DescribeReservedInstancesListingsResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListings = builder.reservedInstancesListings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstancesListings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedInstancesListings() {
        return reservedInstancesListings != null && !(reservedInstancesListings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstancesListings} method.
     * </p>
     * 
     * @return Information about the Reserved Instance listing.
     */
    public final List<ReservedInstancesListing> reservedInstancesListings() {
        return reservedInstancesListings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstancesListings() ? reservedInstancesListings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsResponse)) {
            return false;
        }
        DescribeReservedInstancesListingsResponse other = (DescribeReservedInstancesListingsResponse) obj;
        return hasReservedInstancesListings() == other.hasReservedInstancesListings()
                && Objects.equals(reservedInstancesListings(), other.reservedInstancesListings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedInstancesListingsResponse")
                .add("ReservedInstancesListings", hasReservedInstancesListings() ? reservedInstancesListings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesListings":
            return Optional.ofNullable(clazz.cast(reservedInstancesListings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesListingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesListingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstancesListingsResponse> {
        /**
         * <p>
         * Information about the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings);

        /**
         * <p>
         * Information about the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings);

        /**
         * <p>
         * Information about the Reserved Instance listing.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReservedInstancesListing>.Builder}
         * avoiding the need to create one manually via {@link List<ReservedInstancesListing>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesListing>.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedInstancesListings(List<ReservedInstancesListing>)}.
         * 
         * @param reservedInstancesListings
         *        a consumer that will call methods on {@link List<ReservedInstancesListing>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstancesListings(List<ReservedInstancesListing>)
         */
        Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ReservedInstancesListing> reservedInstancesListings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsResponse model) {
            super(model);
            reservedInstancesListings(model.reservedInstancesListings);
        }

        public final List<ReservedInstancesListing.Builder> getReservedInstancesListings() {
            List<ReservedInstancesListing.Builder> result = ReservedInstancesListingListCopier
                    .copyToBuilder(this.reservedInstancesListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstancesListings(Collection<ReservedInstancesListing.BuilderImpl> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copyFromBuilder(reservedInstancesListings);
        }

        @Override
        public final Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings) {
            reservedInstancesListings(Arrays.asList(reservedInstancesListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings) {
            reservedInstancesListings(Stream.of(reservedInstancesListings)
                    .map(c -> ReservedInstancesListing.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstancesListingsResponse build() {
            return new DescribeReservedInstancesListingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
