/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpamScopesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIpamScopesResponse.Builder, DescribeIpamScopesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeIpamScopesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<IpamScope>> IPAM_SCOPES_FIELD = SdkField
            .<List<IpamScope>> builder(MarshallingType.LIST)
            .memberName("IpamScopes")
            .getter(getter(DescribeIpamScopesResponse::ipamScopes))
            .setter(setter(Builder::ipamScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeSet")
                    .unmarshallLocationName("ipamScopeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamScope> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamScope::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IPAM_SCOPES_FIELD));

    private final String nextToken;

    private final List<IpamScope> ipamScopes;

    private DescribeIpamScopesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamScopes = builder.ipamScopes;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamScopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpamScopes() {
        return ipamScopes != null && !(ipamScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scopes you want information on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamScopes} method.
     * </p>
     * 
     * @return The scopes you want information on.
     */
    public final List<IpamScope> ipamScopes() {
        return ipamScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamScopes() ? ipamScopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamScopesResponse)) {
            return false;
        }
        DescribeIpamScopesResponse other = (DescribeIpamScopesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIpamScopes() == other.hasIpamScopes()
                && Objects.equals(ipamScopes(), other.ipamScopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIpamScopesResponse").add("NextToken", nextToken())
                .add("IpamScopes", hasIpamScopes() ? ipamScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "IpamScopes":
            return Optional.ofNullable(clazz.cast(ipamScopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamScopesResponse, T> g) {
        return obj -> g.apply((DescribeIpamScopesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIpamScopesResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The scopes you want information on.
         * </p>
         * 
         * @param ipamScopes
         *        The scopes you want information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamScopes(Collection<IpamScope> ipamScopes);

        /**
         * <p>
         * The scopes you want information on.
         * </p>
         * 
         * @param ipamScopes
         *        The scopes you want information on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamScopes(IpamScope... ipamScopes);

        /**
         * <p>
         * The scopes you want information on.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<IpamScope>.Builder} avoiding the
         * need to create one manually via {@link List<IpamScope>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpamScope>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipamScopes(List<IpamScope>)}.
         * 
         * @param ipamScopes
         *        a consumer that will call methods on {@link List<IpamScope>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamScopes(List<IpamScope>)
         */
        Builder ipamScopes(Consumer<IpamScope.Builder>... ipamScopes);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<IpamScope> ipamScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamScopesResponse model) {
            super(model);
            nextToken(model.nextToken);
            ipamScopes(model.ipamScopes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamScope.Builder> getIpamScopes() {
            List<IpamScope.Builder> result = IpamScopeSetCopier.copyToBuilder(this.ipamScopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamScopes(Collection<IpamScope.BuilderImpl> ipamScopes) {
            this.ipamScopes = IpamScopeSetCopier.copyFromBuilder(ipamScopes);
        }

        @Override
        public final Builder ipamScopes(Collection<IpamScope> ipamScopes) {
            this.ipamScopes = IpamScopeSetCopier.copy(ipamScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamScopes(IpamScope... ipamScopes) {
            ipamScopes(Arrays.asList(ipamScopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamScopes(Consumer<IpamScope.Builder>... ipamScopes) {
            ipamScopes(Stream.of(ipamScopes).map(c -> IpamScope.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamScopesResponse build() {
            return new DescribeIpamScopesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
