/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportImageTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeExportImageTasksResponse.Builder, DescribeExportImageTasksResponse> {
    private static final SdkField<List<ExportImageTask>> EXPORT_IMAGE_TASKS_FIELD = SdkField
            .<List<ExportImageTask>> builder(MarshallingType.LIST)
            .memberName("ExportImageTasks")
            .getter(getter(DescribeExportImageTasksResponse::exportImageTasks))
            .setter(setter(Builder::exportImageTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskSet")
                    .unmarshallLocationName("exportImageTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ExportImageTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportImageTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeExportImageTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_IMAGE_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExportImageTask> exportImageTasks;

    private final String nextToken;

    private DescribeExportImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportImageTasks = builder.exportImageTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportImageTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportImageTasks() {
        return exportImageTasks != null && !(exportImageTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the export image tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportImageTasks} method.
     * </p>
     * 
     * @return Information about the export image tasks.
     */
    public final List<ExportImageTask> exportImageTasks() {
        return exportImageTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportImageTasks() ? exportImageTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportImageTasksResponse)) {
            return false;
        }
        DescribeExportImageTasksResponse other = (DescribeExportImageTasksResponse) obj;
        return hasExportImageTasks() == other.hasExportImageTasks()
                && Objects.equals(exportImageTasks(), other.exportImageTasks()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExportImageTasksResponse")
                .add("ExportImageTasks", hasExportImageTasks() ? exportImageTasks() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportImageTasks":
            return Optional.ofNullable(clazz.cast(exportImageTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportImageTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportImageTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportImageTasksResponse> {
        /**
         * <p>
         * Information about the export image tasks.
         * </p>
         * 
         * @param exportImageTasks
         *        Information about the export image tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportImageTasks(Collection<ExportImageTask> exportImageTasks);

        /**
         * <p>
         * Information about the export image tasks.
         * </p>
         * 
         * @param exportImageTasks
         *        Information about the export image tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportImageTasks(ExportImageTask... exportImageTasks);

        /**
         * <p>
         * Information about the export image tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExportImageTask>.Builder} avoiding
         * the need to create one manually via {@link List<ExportImageTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportImageTask>.Builder#build()} is called immediately and
         * its result is passed to {@link #exportImageTasks(List<ExportImageTask>)}.
         * 
         * @param exportImageTasks
         *        a consumer that will call methods on {@link List<ExportImageTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportImageTasks(List<ExportImageTask>)
         */
        Builder exportImageTasks(Consumer<ExportImageTask.Builder>... exportImageTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ExportImageTask> exportImageTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportImageTasksResponse model) {
            super(model);
            exportImageTasks(model.exportImageTasks);
            nextToken(model.nextToken);
        }

        public final List<ExportImageTask.Builder> getExportImageTasks() {
            List<ExportImageTask.Builder> result = ExportImageTaskListCopier.copyToBuilder(this.exportImageTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportImageTasks(Collection<ExportImageTask.BuilderImpl> exportImageTasks) {
            this.exportImageTasks = ExportImageTaskListCopier.copyFromBuilder(exportImageTasks);
        }

        @Override
        public final Builder exportImageTasks(Collection<ExportImageTask> exportImageTasks) {
            this.exportImageTasks = ExportImageTaskListCopier.copy(exportImageTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportImageTasks(ExportImageTask... exportImageTasks) {
            exportImageTasks(Arrays.asList(exportImageTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportImageTasks(Consumer<ExportImageTask.Builder>... exportImageTasks) {
            exportImageTasks(Stream.of(exportImageTasks).map(c -> ExportImageTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeExportImageTasksResponse build() {
            return new DescribeExportImageTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
