/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDhcpOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeDhcpOptionsResponse.Builder, DescribeDhcpOptionsResponse> {
    private static final SdkField<List<DhcpOptions>> DHCP_OPTIONS_FIELD = SdkField
            .<List<DhcpOptions>> builder(MarshallingType.LIST)
            .memberName("DhcpOptions")
            .getter(getter(DescribeDhcpOptionsResponse::dhcpOptions))
            .setter(setter(Builder::dhcpOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsSet")
                    .unmarshallLocationName("dhcpOptionsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DhcpOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(DhcpOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeDhcpOptionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_OPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DhcpOptions> dhcpOptions;

    private final String nextToken;

    private DescribeDhcpOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dhcpOptions = builder.dhcpOptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DhcpOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDhcpOptions() {
        return dhcpOptions != null && !(dhcpOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more DHCP options sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDhcpOptions} method.
     * </p>
     * 
     * @return Information about one or more DHCP options sets.
     */
    public final List<DhcpOptions> dhcpOptions() {
        return dhcpOptions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDhcpOptions() ? dhcpOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsResponse)) {
            return false;
        }
        DescribeDhcpOptionsResponse other = (DescribeDhcpOptionsResponse) obj;
        return hasDhcpOptions() == other.hasDhcpOptions() && Objects.equals(dhcpOptions(), other.dhcpOptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDhcpOptionsResponse").add("DhcpOptions", hasDhcpOptions() ? dhcpOptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptions":
            return Optional.ofNullable(clazz.cast(dhcpOptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDhcpOptionsResponse, T> g) {
        return obj -> g.apply((DescribeDhcpOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions... dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DhcpOptions>.Builder} avoiding the
         * need to create one manually via {@link List<DhcpOptions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DhcpOptions>.Builder#build()} is called immediately and its
         * result is passed to {@link #dhcpOptions(List<DhcpOptions>)}.
         * 
         * @param dhcpOptions
         *        a consumer that will call methods on {@link List<DhcpOptions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpOptions(List<DhcpOptions>)
         */
        Builder dhcpOptions(Consumer<DhcpOptions.Builder>... dhcpOptions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DhcpOptions> dhcpOptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsResponse model) {
            super(model);
            dhcpOptions(model.dhcpOptions);
            nextToken(model.nextToken);
        }

        public final List<DhcpOptions.Builder> getDhcpOptions() {
            List<DhcpOptions.Builder> result = DhcpOptionsListCopier.copyToBuilder(this.dhcpOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDhcpOptions(Collection<DhcpOptions.BuilderImpl> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copyFromBuilder(dhcpOptions);
        }

        @Override
        public final Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(DhcpOptions... dhcpOptions) {
            dhcpOptions(Arrays.asList(dhcpOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(Consumer<DhcpOptions.Builder>... dhcpOptions) {
            dhcpOptions(Stream.of(dhcpOptions).map(c -> DhcpOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDhcpOptionsResponse build() {
            return new DescribeDhcpOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
