/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTransitGatewayMulticastGroupSourcesResponse extends Ec2Response
        implements
        ToCopyableBuilder<DeregisterTransitGatewayMulticastGroupSourcesResponse.Builder, DeregisterTransitGatewayMulticastGroupSourcesResponse> {
    private static final SdkField<TransitGatewayMulticastDeregisteredGroupSources> DEREGISTERED_MULTICAST_GROUP_SOURCES_FIELD = SdkField
            .<TransitGatewayMulticastDeregisteredGroupSources> builder(MarshallingType.SDK_POJO)
            .memberName("DeregisteredMulticastGroupSources")
            .getter(getter(DeregisterTransitGatewayMulticastGroupSourcesResponse::deregisteredMulticastGroupSources))
            .setter(setter(Builder::deregisteredMulticastGroupSources))
            .constructor(TransitGatewayMulticastDeregisteredGroupSources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregisteredMulticastGroupSources")
                    .unmarshallLocationName("deregisteredMulticastGroupSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEREGISTERED_MULTICAST_GROUP_SOURCES_FIELD));

    private final TransitGatewayMulticastDeregisteredGroupSources deregisteredMulticastGroupSources;

    private DeregisterTransitGatewayMulticastGroupSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.deregisteredMulticastGroupSources = builder.deregisteredMulticastGroupSources;
    }

    /**
     * <p>
     * Information about the deregistered group sources.
     * </p>
     * 
     * @return Information about the deregistered group sources.
     */
    public final TransitGatewayMulticastDeregisteredGroupSources deregisteredMulticastGroupSources() {
        return deregisteredMulticastGroupSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deregisteredMulticastGroupSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTransitGatewayMulticastGroupSourcesResponse)) {
            return false;
        }
        DeregisterTransitGatewayMulticastGroupSourcesResponse other = (DeregisterTransitGatewayMulticastGroupSourcesResponse) obj;
        return Objects.equals(deregisteredMulticastGroupSources(), other.deregisteredMulticastGroupSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterTransitGatewayMulticastGroupSourcesResponse")
                .add("DeregisteredMulticastGroupSources", deregisteredMulticastGroupSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeregisteredMulticastGroupSources":
            return Optional.ofNullable(clazz.cast(deregisteredMulticastGroupSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTransitGatewayMulticastGroupSourcesResponse, T> g) {
        return obj -> g.apply((DeregisterTransitGatewayMulticastGroupSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterTransitGatewayMulticastGroupSourcesResponse> {
        /**
         * <p>
         * Information about the deregistered group sources.
         * </p>
         * 
         * @param deregisteredMulticastGroupSources
         *        Information about the deregistered group sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisteredMulticastGroupSources(
                TransitGatewayMulticastDeregisteredGroupSources deregisteredMulticastGroupSources);

        /**
         * <p>
         * Information about the deregistered group sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayMulticastDeregisteredGroupSources.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayMulticastDeregisteredGroupSources#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastDeregisteredGroupSources.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #deregisteredMulticastGroupSources(TransitGatewayMulticastDeregisteredGroupSources)}.
         * 
         * @param deregisteredMulticastGroupSources
         *        a consumer that will call methods on {@link TransitGatewayMulticastDeregisteredGroupSources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deregisteredMulticastGroupSources(TransitGatewayMulticastDeregisteredGroupSources)
         */
        default Builder deregisteredMulticastGroupSources(
                Consumer<TransitGatewayMulticastDeregisteredGroupSources.Builder> deregisteredMulticastGroupSources) {
            return deregisteredMulticastGroupSources(TransitGatewayMulticastDeregisteredGroupSources.builder()
                    .applyMutation(deregisteredMulticastGroupSources).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastDeregisteredGroupSources deregisteredMulticastGroupSources;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTransitGatewayMulticastGroupSourcesResponse model) {
            super(model);
            deregisteredMulticastGroupSources(model.deregisteredMulticastGroupSources);
        }

        public final TransitGatewayMulticastDeregisteredGroupSources.Builder getDeregisteredMulticastGroupSources() {
            return deregisteredMulticastGroupSources != null ? deregisteredMulticastGroupSources.toBuilder() : null;
        }

        public final void setDeregisteredMulticastGroupSources(
                TransitGatewayMulticastDeregisteredGroupSources.BuilderImpl deregisteredMulticastGroupSources) {
            this.deregisteredMulticastGroupSources = deregisteredMulticastGroupSources != null ? deregisteredMulticastGroupSources
                    .build() : null;
        }

        @Override
        public final Builder deregisteredMulticastGroupSources(
                TransitGatewayMulticastDeregisteredGroupSources deregisteredMulticastGroupSources) {
            this.deregisteredMulticastGroupSources = deregisteredMulticastGroupSources;
            return this;
        }

        @Override
        public DeregisterTransitGatewayMulticastGroupSourcesResponse build() {
            return new DeregisterTransitGatewayMulticastGroupSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
