/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTransitGatewayMulticastGroupMembersResponse extends Ec2Response
        implements
        ToCopyableBuilder<DeregisterTransitGatewayMulticastGroupMembersResponse.Builder, DeregisterTransitGatewayMulticastGroupMembersResponse> {
    private static final SdkField<TransitGatewayMulticastDeregisteredGroupMembers> DEREGISTERED_MULTICAST_GROUP_MEMBERS_FIELD = SdkField
            .<TransitGatewayMulticastDeregisteredGroupMembers> builder(MarshallingType.SDK_POJO)
            .memberName("DeregisteredMulticastGroupMembers")
            .getter(getter(DeregisterTransitGatewayMulticastGroupMembersResponse::deregisteredMulticastGroupMembers))
            .setter(setter(Builder::deregisteredMulticastGroupMembers))
            .constructor(TransitGatewayMulticastDeregisteredGroupMembers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeregisteredMulticastGroupMembers")
                    .unmarshallLocationName("deregisteredMulticastGroupMembers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEREGISTERED_MULTICAST_GROUP_MEMBERS_FIELD));

    private final TransitGatewayMulticastDeregisteredGroupMembers deregisteredMulticastGroupMembers;

    private DeregisterTransitGatewayMulticastGroupMembersResponse(BuilderImpl builder) {
        super(builder);
        this.deregisteredMulticastGroupMembers = builder.deregisteredMulticastGroupMembers;
    }

    /**
     * <p>
     * Information about the deregistered members.
     * </p>
     * 
     * @return Information about the deregistered members.
     */
    public final TransitGatewayMulticastDeregisteredGroupMembers deregisteredMulticastGroupMembers() {
        return deregisteredMulticastGroupMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deregisteredMulticastGroupMembers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTransitGatewayMulticastGroupMembersResponse)) {
            return false;
        }
        DeregisterTransitGatewayMulticastGroupMembersResponse other = (DeregisterTransitGatewayMulticastGroupMembersResponse) obj;
        return Objects.equals(deregisteredMulticastGroupMembers(), other.deregisteredMulticastGroupMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterTransitGatewayMulticastGroupMembersResponse")
                .add("DeregisteredMulticastGroupMembers", deregisteredMulticastGroupMembers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeregisteredMulticastGroupMembers":
            return Optional.ofNullable(clazz.cast(deregisteredMulticastGroupMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTransitGatewayMulticastGroupMembersResponse, T> g) {
        return obj -> g.apply((DeregisterTransitGatewayMulticastGroupMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterTransitGatewayMulticastGroupMembersResponse> {
        /**
         * <p>
         * Information about the deregistered members.
         * </p>
         * 
         * @param deregisteredMulticastGroupMembers
         *        Information about the deregistered members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisteredMulticastGroupMembers(
                TransitGatewayMulticastDeregisteredGroupMembers deregisteredMulticastGroupMembers);

        /**
         * <p>
         * Information about the deregistered members.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayMulticastDeregisteredGroupMembers.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayMulticastDeregisteredGroupMembers#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastDeregisteredGroupMembers.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #deregisteredMulticastGroupMembers(TransitGatewayMulticastDeregisteredGroupMembers)}.
         * 
         * @param deregisteredMulticastGroupMembers
         *        a consumer that will call methods on {@link TransitGatewayMulticastDeregisteredGroupMembers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deregisteredMulticastGroupMembers(TransitGatewayMulticastDeregisteredGroupMembers)
         */
        default Builder deregisteredMulticastGroupMembers(
                Consumer<TransitGatewayMulticastDeregisteredGroupMembers.Builder> deregisteredMulticastGroupMembers) {
            return deregisteredMulticastGroupMembers(TransitGatewayMulticastDeregisteredGroupMembers.builder()
                    .applyMutation(deregisteredMulticastGroupMembers).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastDeregisteredGroupMembers deregisteredMulticastGroupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTransitGatewayMulticastGroupMembersResponse model) {
            super(model);
            deregisteredMulticastGroupMembers(model.deregisteredMulticastGroupMembers);
        }

        public final TransitGatewayMulticastDeregisteredGroupMembers.Builder getDeregisteredMulticastGroupMembers() {
            return deregisteredMulticastGroupMembers != null ? deregisteredMulticastGroupMembers.toBuilder() : null;
        }

        public final void setDeregisteredMulticastGroupMembers(
                TransitGatewayMulticastDeregisteredGroupMembers.BuilderImpl deregisteredMulticastGroupMembers) {
            this.deregisteredMulticastGroupMembers = deregisteredMulticastGroupMembers != null ? deregisteredMulticastGroupMembers
                    .build() : null;
        }

        @Override
        public final Builder deregisteredMulticastGroupMembers(
                TransitGatewayMulticastDeregisteredGroupMembers deregisteredMulticastGroupMembers) {
            this.deregisteredMulticastGroupMembers = deregisteredMulticastGroupMembers;
            return this;
        }

        @Override
        public DeregisterTransitGatewayMulticastGroupMembersResponse build() {
            return new DeregisterTransitGatewayMulticastGroupMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
