/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a customer gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerGateway implements SdkPojo, Serializable, ToCopyableBuilder<CustomerGateway.Builder, CustomerGateway> {
    private static final SdkField<String> BGP_ASN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BgpAsn")
            .getter(getter(CustomerGateway::bgpAsn))
            .setter(setter(Builder::bgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpAsn")
                    .unmarshallLocationName("bgpAsn").build()).build();

    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerGatewayId")
            .getter(getter(CustomerGateway::customerGatewayId))
            .setter(setter(Builder::customerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId")
                    .unmarshallLocationName("customerGatewayId").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddress")
            .getter(getter(CustomerGateway::ipAddress))
            .setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress")
                    .unmarshallLocationName("ipAddress").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn")
            .getter(getter(CustomerGateway::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn")
                    .unmarshallLocationName("certificateArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CustomerGateway::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(CustomerGateway::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceName")
            .getter(getter(CustomerGateway::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("deviceName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CustomerGateway::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BGP_ASN_FIELD,
            CUSTOMER_GATEWAY_ID_FIELD, IP_ADDRESS_FIELD, CERTIFICATE_ARN_FIELD, STATE_FIELD, TYPE_FIELD, DEVICE_NAME_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bgpAsn;

    private final String customerGatewayId;

    private final String ipAddress;

    private final String certificateArn;

    private final String state;

    private final String type;

    private final String deviceName;

    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.certificateArn = builder.certificateArn;
        this.state = builder.state;
        this.type = builder.type;
        this.deviceName = builder.deviceName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     * </p>
     * 
     * @return The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    public final String bgpAsn() {
        return bgpAsn;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public final String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The Internet-routable IP address of the customer gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the customer gateway's outside interface.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     * </p>
     * 
     * @return The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The name of customer gateway device.
     * </p>
     * 
     * @return The name of customer gateway device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the customer gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the customer gateway.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway) obj;
        return Objects.equals(bgpAsn(), other.bgpAsn()) && Objects.equals(customerGatewayId(), other.customerGatewayId())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(state(), other.state()) && Objects.equals(type(), other.type())
                && Objects.equals(deviceName(), other.deviceName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerGateway").add("BgpAsn", bgpAsn()).add("CustomerGatewayId", customerGatewayId())
                .add("IpAddress", ipAddress()).add("CertificateArn", certificateArn()).add("State", state()).add("Type", type())
                .add("DeviceName", deviceName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BgpAsn":
            return Optional.ofNullable(clazz.cast(bgpAsn()));
        case "CustomerGatewayId":
            return Optional.ofNullable(clazz.cast(customerGatewayId()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerGateway, T> g) {
        return obj -> g.apply((CustomerGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerGateway> {
        /**
         * <p>
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * 
         * @param bgpAsn
         *        The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpAsn(String bgpAsn);

        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The Internet-routable IP address of the customer gateway's outside interface.
         * </p>
         * 
         * @param ipAddress
         *        The Internet-routable IP address of the customer gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) for the customer gateway certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * </p>
         * 
         * @param state
         *        The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The name of customer gateway device.
         * </p>
         * 
         * @param deviceName
         *        The name of customer gateway device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String bgpAsn;

        private String customerGatewayId;

        private String ipAddress;

        private String certificateArn;

        private String state;

        private String type;

        private String deviceName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            bgpAsn(model.bgpAsn);
            customerGatewayId(model.customerGatewayId);
            ipAddress(model.ipAddress);
            certificateArn(model.certificateArn);
            state(model.state);
            type(model.type);
            deviceName(model.deviceName);
            tags(model.tags);
        }

        public final String getBgpAsn() {
            return bgpAsn;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomerGateway build() {
            return new CustomerGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
