/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNatGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateNatGatewayResponse.Builder, CreateNatGatewayResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateNatGatewayResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<NatGateway> NAT_GATEWAY_FIELD = SdkField
            .<NatGateway> builder(MarshallingType.SDK_POJO)
            .memberName("NatGateway")
            .getter(getter(CreateNatGatewayResponse::natGateway))
            .setter(setter(Builder::natGateway))
            .constructor(NatGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGateway")
                    .unmarshallLocationName("natGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAT_GATEWAY_FIELD));

    private final String clientToken;

    private final NatGateway natGateway;

    private CreateNatGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.natGateway = builder.natGateway;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was
     * provided in the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
     *         token was provided in the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Information about the NAT gateway.
     * </p>
     * 
     * @return Information about the NAT gateway.
     */
    public final NatGateway natGateway() {
        return natGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(natGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayResponse)) {
            return false;
        }
        CreateNatGatewayResponse other = (CreateNatGatewayResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(natGateway(), other.natGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNatGatewayResponse").add("ClientToken", clientToken()).add("NatGateway", natGateway())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "NatGateway":
            return Optional.ofNullable(clazz.cast(natGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNatGatewayResponse, T> g) {
        return obj -> g.apply((CreateNatGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateNatGatewayResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token
         * was provided in the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
         *        token was provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the NAT gateway.
         * </p>
         * 
         * @param natGateway
         *        Information about the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateway(NatGateway natGateway);

        /**
         * <p>
         * Information about the NAT gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link NatGateway.Builder} avoiding the need to
         * create one manually via {@link NatGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link NatGateway.Builder#build()} is called immediately and its result
         * is passed to {@link #natGateway(NatGateway)}.
         * 
         * @param natGateway
         *        a consumer that will call methods on {@link NatGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGateway(NatGateway)
         */
        default Builder natGateway(Consumer<NatGateway.Builder> natGateway) {
            return natGateway(NatGateway.builder().applyMutation(natGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String clientToken;

        private NatGateway natGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNatGatewayResponse model) {
            super(model);
            clientToken(model.clientToken);
            natGateway(model.natGateway);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final NatGateway.Builder getNatGateway() {
            return natGateway != null ? natGateway.toBuilder() : null;
        }

        public final void setNatGateway(NatGateway.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        @Override
        public final Builder natGateway(NatGateway natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        @Override
        public CreateNatGatewayResponse build() {
            return new CreateNatGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
