/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.PrefixListAssociation;

public class GetManagedPrefixListAssociationsIterable
implements SdkIterable<GetManagedPrefixListAssociationsResponse> {
    private final Ec2Client client;
    private final GetManagedPrefixListAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetManagedPrefixListAssociationsIterable(Ec2Client client, GetManagedPrefixListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetManagedPrefixListAssociationsResponseFetcher();
    }

    public Iterator<GetManagedPrefixListAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrefixListAssociation> prefixListAssociations() {
        Function<GetManagedPrefixListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixListAssociations() != null) {
                return response.prefixListAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetManagedPrefixListAssociationsResponseFetcher
    implements SyncPageFetcher<GetManagedPrefixListAssociationsResponse> {
        private GetManagedPrefixListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetManagedPrefixListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetManagedPrefixListAssociationsResponse nextPage(GetManagedPrefixListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetManagedPrefixListAssociationsIterable.this.client.getManagedPrefixListAssociations(GetManagedPrefixListAssociationsIterable.this.firstRequest);
            }
            return GetManagedPrefixListAssociationsIterable.this.client.getManagedPrefixListAssociations((GetManagedPrefixListAssociationsRequest)((Object)GetManagedPrefixListAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

