/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.StatusName;
import software.amazon.awssdk.services.ec2.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStatusDetails> {
    private static final SdkField<Instant> IMPAIRED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImpairedSince").getter(InstanceStatusDetails.getter(InstanceStatusDetails::impairedSince)).setter(InstanceStatusDetails.setter(Builder::impairedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairedSince").unmarshallLocationName("impairedSince").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InstanceStatusDetails.getter(InstanceStatusDetails::nameAsString)).setter(InstanceStatusDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceStatusDetails.getter(InstanceStatusDetails::statusAsString)).setter(InstanceStatusDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPAIRED_SINCE_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant impairedSince;
    private final String name;
    private final String status;

    private InstanceStatusDetails(BuilderImpl builder) {
        this.impairedSince = builder.impairedSince;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final Instant impairedSince() {
        return this.impairedSince;
    }

    public final StatusName name() {
        return StatusName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.impairedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusDetails)) {
            return false;
        }
        InstanceStatusDetails other = (InstanceStatusDetails)obj;
        return Objects.equals(this.impairedSince(), other.impairedSince()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceStatusDetails").add("ImpairedSince", (Object)this.impairedSince()).add("Name", (Object)this.nameAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpairedSince": {
                return Optional.ofNullable(clazz.cast(this.impairedSince()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatusDetails, T> g) {
        return obj -> g.apply((InstanceStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant impairedSince;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusDetails model) {
            this.impairedSince(model.impairedSince);
            this.name(model.name);
            this.status(model.status);
        }

        public final Instant getImpairedSince() {
            return this.impairedSince;
        }

        public final void setImpairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
        }

        @Override
        @Transient
        public final Builder impairedSince(Instant impairedSince) {
            this.impairedSince = impairedSince;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(StatusName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public InstanceStatusDetails build() {
            return new InstanceStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStatusDetails> {
        public Builder impairedSince(Instant var1);

        public Builder name(String var1);

        public Builder name(StatusName var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

