/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GpuDeviceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GpuDeviceInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GpuDeviceInfo.getter(GpuDeviceInfo::name)).setter(GpuDeviceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manufacturer").getter(GpuDeviceInfo.getter(GpuDeviceInfo::manufacturer)).setter(GpuDeviceInfo.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").unmarshallLocationName("manufacturer").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(GpuDeviceInfo.getter(GpuDeviceInfo::count)).setter(GpuDeviceInfo.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<GpuDeviceMemoryInfo> MEMORY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryInfo").getter(GpuDeviceInfo.getter(GpuDeviceInfo::memoryInfo)).setter(GpuDeviceInfo.setter(Builder::memoryInfo)).constructor(GpuDeviceMemoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo").unmarshallLocationName("memoryInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MANUFACTURER_FIELD, COUNT_FIELD, MEMORY_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String manufacturer;
    private final Integer count;
    private final GpuDeviceMemoryInfo memoryInfo;

    private GpuDeviceInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.count = builder.count;
        this.memoryInfo = builder.memoryInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String manufacturer() {
        return this.manufacturer;
    }

    public final Integer count() {
        return this.count;
    }

    public final GpuDeviceMemoryInfo memoryInfo() {
        return this.memoryInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuDeviceInfo)) {
            return false;
        }
        GpuDeviceInfo other = (GpuDeviceInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.manufacturer(), other.manufacturer()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.memoryInfo(), other.memoryInfo());
    }

    public final String toString() {
        return ToString.builder((String)"GpuDeviceInfo").add("Name", (Object)this.name()).add("Manufacturer", (Object)this.manufacturer()).add("Count", (Object)this.count()).add("MemoryInfo", (Object)this.memoryInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "MemoryInfo": {
                return Optional.ofNullable(clazz.cast(this.memoryInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GpuDeviceInfo, T> g) {
        return obj -> g.apply((GpuDeviceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String manufacturer;
        private Integer count;
        private GpuDeviceMemoryInfo memoryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuDeviceInfo model) {
            this.name(model.name);
            this.manufacturer(model.manufacturer);
            this.count(model.count);
            this.memoryInfo(model.memoryInfo);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        @Transient
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final GpuDeviceMemoryInfo.Builder getMemoryInfo() {
            return this.memoryInfo != null ? this.memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(GpuDeviceMemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder memoryInfo(GpuDeviceMemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public GpuDeviceInfo build() {
            return new GpuDeviceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GpuDeviceInfo> {
        public Builder name(String var1);

        public Builder manufacturer(String var1);

        public Builder count(Integer var1);

        public Builder memoryInfo(GpuDeviceMemoryInfo var1);

        default public Builder memoryInfo(Consumer<GpuDeviceMemoryInfo.Builder> memoryInfo) {
            return this.memoryInfo((GpuDeviceMemoryInfo)((GpuDeviceMemoryInfo.Builder)GpuDeviceMemoryInfo.builder().applyMutation(memoryInfo)).build());
        }
    }
}

