/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.FastSnapshotRestoreStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFastSnapshotRestoreSuccessItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeFastSnapshotRestoreSuccessItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::snapshotId)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::availabilityZone)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::stateAsString)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::stateTransitionReason)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").unmarshallLocationName("stateTransitionReason").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::ownerId)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAlias").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::ownerAlias)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::ownerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").unmarshallLocationName("ownerAlias").build()}).build();
    private static final SdkField<Instant> ENABLING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnablingTime").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::enablingTime)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::enablingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablingTime").unmarshallLocationName("enablingTime").build()}).build();
    private static final SdkField<Instant> OPTIMIZING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OptimizingTime").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::optimizingTime)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::optimizingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizingTime").unmarshallLocationName("optimizingTime").build()}).build();
    private static final SdkField<Instant> ENABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnabledTime").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::enabledTime)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::enabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledTime").unmarshallLocationName("enabledTime").build()}).build();
    private static final SdkField<Instant> DISABLING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisablingTime").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::disablingTime)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::disablingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisablingTime").unmarshallLocationName("disablingTime").build()}).build();
    private static final SdkField<Instant> DISABLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisabledTime").getter(DescribeFastSnapshotRestoreSuccessItem.getter(DescribeFastSnapshotRestoreSuccessItem::disabledTime)).setter(DescribeFastSnapshotRestoreSuccessItem.setter(Builder::disabledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledTime").unmarshallLocationName("disabledTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, OWNER_ID_FIELD, OWNER_ALIAS_FIELD, ENABLING_TIME_FIELD, OPTIMIZING_TIME_FIELD, ENABLED_TIME_FIELD, DISABLING_TIME_FIELD, DISABLED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final String availabilityZone;
    private final String state;
    private final String stateTransitionReason;
    private final String ownerId;
    private final String ownerAlias;
    private final Instant enablingTime;
    private final Instant optimizingTime;
    private final Instant enabledTime;
    private final Instant disablingTime;
    private final Instant disabledTime;

    private DescribeFastSnapshotRestoreSuccessItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.enablingTime = builder.enablingTime;
        this.optimizingTime = builder.optimizingTime;
        this.enabledTime = builder.enabledTime;
        this.disablingTime = builder.disablingTime;
        this.disabledTime = builder.disabledTime;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final FastSnapshotRestoreStateCode state() {
        return FastSnapshotRestoreStateCode.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ownerAlias() {
        return this.ownerAlias;
    }

    public final Instant enablingTime() {
        return this.enablingTime;
    }

    public final Instant optimizingTime() {
        return this.optimizingTime;
    }

    public final Instant enabledTime() {
        return this.enabledTime;
    }

    public final Instant disablingTime() {
        return this.disablingTime;
    }

    public final Instant disabledTime() {
        return this.disabledTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.disablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFastSnapshotRestoreSuccessItem)) {
            return false;
        }
        DescribeFastSnapshotRestoreSuccessItem other = (DescribeFastSnapshotRestoreSuccessItem)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ownerAlias(), other.ownerAlias()) && Objects.equals(this.enablingTime(), other.enablingTime()) && Objects.equals(this.optimizingTime(), other.optimizingTime()) && Objects.equals(this.enabledTime(), other.enabledTime()) && Objects.equals(this.disablingTime(), other.disablingTime()) && Objects.equals(this.disabledTime(), other.disabledTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFastSnapshotRestoreSuccessItem").add("SnapshotId", (Object)this.snapshotId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("State", (Object)this.stateAsString()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("OwnerId", (Object)this.ownerId()).add("OwnerAlias", (Object)this.ownerAlias()).add("EnablingTime", (Object)this.enablingTime()).add("OptimizingTime", (Object)this.optimizingTime()).add("EnabledTime", (Object)this.enabledTime()).add("DisablingTime", (Object)this.disablingTime()).add("DisabledTime", (Object)this.disabledTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "OwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.ownerAlias()));
            }
            case "EnablingTime": {
                return Optional.ofNullable(clazz.cast(this.enablingTime()));
            }
            case "OptimizingTime": {
                return Optional.ofNullable(clazz.cast(this.optimizingTime()));
            }
            case "EnabledTime": {
                return Optional.ofNullable(clazz.cast(this.enabledTime()));
            }
            case "DisablingTime": {
                return Optional.ofNullable(clazz.cast(this.disablingTime()));
            }
            case "DisabledTime": {
                return Optional.ofNullable(clazz.cast(this.disabledTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFastSnapshotRestoreSuccessItem, T> g) {
        return obj -> g.apply((DescribeFastSnapshotRestoreSuccessItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private String availabilityZone;
        private String state;
        private String stateTransitionReason;
        private String ownerId;
        private String ownerAlias;
        private Instant enablingTime;
        private Instant optimizingTime;
        private Instant enabledTime;
        private Instant disablingTime;
        private Instant disabledTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFastSnapshotRestoreSuccessItem model) {
            this.snapshotId(model.snapshotId);
            this.availabilityZone(model.availabilityZone);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.ownerId(model.ownerId);
            this.ownerAlias(model.ownerAlias);
            this.enablingTime(model.enablingTime);
            this.optimizingTime(model.optimizingTime);
            this.enabledTime(model.enabledTime);
            this.disablingTime(model.disablingTime);
            this.disabledTime(model.disabledTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(FastSnapshotRestoreStateCode state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        @Transient
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        @Override
        @Transient
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final Instant getEnablingTime() {
            return this.enablingTime;
        }

        public final void setEnablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
        }

        @Override
        @Transient
        public final Builder enablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
            return this;
        }

        public final Instant getOptimizingTime() {
            return this.optimizingTime;
        }

        public final void setOptimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
        }

        @Override
        @Transient
        public final Builder optimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
            return this;
        }

        public final Instant getEnabledTime() {
            return this.enabledTime;
        }

        public final void setEnabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
        }

        @Override
        @Transient
        public final Builder enabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
            return this;
        }

        public final Instant getDisablingTime() {
            return this.disablingTime;
        }

        public final void setDisablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
        }

        @Override
        @Transient
        public final Builder disablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
            return this;
        }

        public final Instant getDisabledTime() {
            return this.disabledTime;
        }

        public final void setDisabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
        }

        @Override
        @Transient
        public final Builder disabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
            return this;
        }

        public DescribeFastSnapshotRestoreSuccessItem build() {
            return new DescribeFastSnapshotRestoreSuccessItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeFastSnapshotRestoreSuccessItem> {
        public Builder snapshotId(String var1);

        public Builder availabilityZone(String var1);

        public Builder state(String var1);

        public Builder state(FastSnapshotRestoreStateCode var1);

        public Builder stateTransitionReason(String var1);

        public Builder ownerId(String var1);

        public Builder ownerAlias(String var1);

        public Builder enablingTime(Instant var1);

        public Builder optimizingTime(Instant var1);

        public Builder enabledTime(Instant var1);

        public Builder disablingTime(Instant var1);

        public Builder disabledTime(Instant var1);
    }
}

