/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TrafficDirection;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRangeRequest;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorRuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficMirrorFilterRuleRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTrafficMirrorFilterRuleRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::trafficMirrorFilterId)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build()}).build();
    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficDirection").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::trafficDirectionAsString)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::trafficDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection").unmarshallLocationName("TrafficDirection").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleNumber").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::ruleNumber)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("RuleNumber").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::ruleActionAsString)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("RuleAction").build()}).build();
    private static final SdkField<TrafficMirrorPortRangeRequest> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationPortRange").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::destinationPortRange)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::destinationPortRange)).constructor(TrafficMirrorPortRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("DestinationPortRange").build()}).build();
    private static final SdkField<TrafficMirrorPortRangeRequest> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourcePortRange").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::sourcePortRange)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::sourcePortRange)).constructor(TrafficMirrorPortRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("SourcePortRange").build()}).build();
    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Protocol").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::protocol)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::destinationCidrBlock)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCidrBlock").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::sourceCidrBlock)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::sourceCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock").unmarshallLocationName("SourceCidrBlock").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::description)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrafficMirrorFilterRuleRequest.getter(CreateTrafficMirrorFilterRuleRequest::clientToken)).setter(CreateTrafficMirrorFilterRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD, RULE_ACTION_FIELD, DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD, PROTOCOL_FIELD, DESTINATION_CIDR_BLOCK_FIELD, SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String trafficMirrorFilterId;
    private final String trafficDirection;
    private final Integer ruleNumber;
    private final String ruleAction;
    private final TrafficMirrorPortRangeRequest destinationPortRange;
    private final TrafficMirrorPortRangeRequest sourcePortRange;
    private final Integer protocol;
    private final String destinationCidrBlock;
    private final String sourceCidrBlock;
    private final String description;
    private final String clientToken;

    private CreateTrafficMirrorFilterRuleRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.protocol = builder.protocol;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public final String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public final TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(this.trafficDirection);
    }

    public final String trafficDirectionAsString() {
        return this.trafficDirection;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    public final TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(this.ruleAction);
    }

    public final String ruleActionAsString() {
        return this.ruleAction;
    }

    public final TrafficMirrorPortRangeRequest destinationPortRange() {
        return this.destinationPortRange;
    }

    public final TrafficMirrorPortRangeRequest sourcePortRange() {
        return this.sourcePortRange;
    }

    public final Integer protocol() {
        return this.protocol;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterRuleRequest)) {
            return false;
        }
        CreateTrafficMirrorFilterRuleRequest other = (CreateTrafficMirrorFilterRuleRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.trafficDirectionAsString(), other.trafficDirectionAsString()) && Objects.equals(this.ruleNumber(), other.ruleNumber()) && Objects.equals(this.ruleActionAsString(), other.ruleActionAsString()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.sourceCidrBlock(), other.sourceCidrBlock()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficMirrorFilterRuleRequest").add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("TrafficDirection", (Object)this.trafficDirectionAsString()).add("RuleNumber", (Object)this.ruleNumber()).add("RuleAction", (Object)this.ruleActionAsString()).add("DestinationPortRange", (Object)this.destinationPortRange()).add("SourcePortRange", (Object)this.sourcePortRange()).add("Protocol", (Object)this.protocol()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("SourceCidrBlock", (Object)this.sourceCidrBlock()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "TrafficDirection": {
                return Optional.ofNullable(clazz.cast(this.trafficDirectionAsString()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleActionAsString()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "SourceCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.sourceCidrBlock()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterRuleRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trafficMirrorFilterId;
        private String trafficDirection;
        private Integer ruleNumber;
        private String ruleAction;
        private TrafficMirrorPortRangeRequest destinationPortRange;
        private TrafficMirrorPortRangeRequest sourcePortRange;
        private Integer protocol;
        private String destinationCidrBlock;
        private String sourceCidrBlock;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterRuleRequest model) {
            super(model);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.trafficDirection(model.trafficDirection);
            this.ruleNumber(model.ruleNumber);
            this.ruleAction(model.ruleAction);
            this.destinationPortRange(model.destinationPortRange);
            this.sourcePortRange(model.sourcePortRange);
            this.protocol(model.protocol);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.sourceCidrBlock(model.sourceCidrBlock);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        @Transient
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final String getTrafficDirection() {
            return this.trafficDirection;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        @Override
        @Transient
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        @Transient
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        @Transient
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        @Transient
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        @Transient
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getDestinationPortRange() {
            return this.destinationPortRange != null ? this.destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRangeRequest.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getSourcePortRange() {
            return this.sourcePortRange != null ? this.sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(TrafficMirrorPortRangeRequest.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        @Transient
        public final Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final Integer getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        @Transient
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorFilterRuleRequest build() {
            return new CreateTrafficMirrorFilterRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficMirrorFilterRuleRequest> {
        public Builder trafficMirrorFilterId(String var1);

        public Builder trafficDirection(String var1);

        public Builder trafficDirection(TrafficDirection var1);

        public Builder ruleNumber(Integer var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(TrafficMirrorRuleAction var1);

        public Builder destinationPortRange(TrafficMirrorPortRangeRequest var1);

        default public Builder destinationPortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> destinationPortRange) {
            return this.destinationPortRange((TrafficMirrorPortRangeRequest)((TrafficMirrorPortRangeRequest.Builder)TrafficMirrorPortRangeRequest.builder().applyMutation(destinationPortRange)).build());
        }

        public Builder sourcePortRange(TrafficMirrorPortRangeRequest var1);

        default public Builder sourcePortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> sourcePortRange) {
            return this.sourcePortRange((TrafficMirrorPortRangeRequest)((TrafficMirrorPortRangeRequest.Builder)TrafficMirrorPortRangeRequest.builder().applyMutation(sourcePortRange)).build());
        }

        public Builder protocol(Integer var1);

        public Builder destinationCidrBlock(String var1);

        public Builder sourceCidrBlock(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

