/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatusItem implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatusItem.Builder, VolumeStatusItem> {
    private static final SdkField<List<VolumeStatusAction>> ACTIONS_FIELD = SdkField
            .<List<VolumeStatusAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(VolumeStatusItem::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSet")
                    .unmarshallLocationName("actionsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeStatusAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeStatusAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(VolumeStatusItem::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(VolumeStatusItem::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<List<VolumeStatusEvent>> EVENTS_FIELD = SdkField
            .<List<VolumeStatusEvent>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(VolumeStatusItem::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsSet")
                    .unmarshallLocationName("eventsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeStatusEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeStatusEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(VolumeStatusItem::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<VolumeStatusInfo> VOLUME_STATUS_FIELD = SdkField
            .<VolumeStatusInfo> builder(MarshallingType.SDK_POJO)
            .memberName("VolumeStatus")
            .getter(getter(VolumeStatusItem::volumeStatus))
            .setter(setter(Builder::volumeStatus))
            .constructor(VolumeStatusInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatus")
                    .unmarshallLocationName("volumeStatus").build()).build();

    private static final SdkField<List<VolumeStatusAttachmentStatus>> ATTACHMENT_STATUSES_FIELD = SdkField
            .<List<VolumeStatusAttachmentStatus>> builder(MarshallingType.LIST)
            .memberName("AttachmentStatuses")
            .getter(getter(VolumeStatusItem::attachmentStatuses))
            .setter(setter(Builder::attachmentStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentStatuses")
                    .unmarshallLocationName("attachmentStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeStatusAttachmentStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeStatusAttachmentStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            AVAILABILITY_ZONE_FIELD, OUTPOST_ARN_FIELD, EVENTS_FIELD, VOLUME_ID_FIELD, VOLUME_STATUS_FIELD,
            ATTACHMENT_STATUSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VolumeStatusAction> actions;

    private final String availabilityZone;

    private final String outpostArn;

    private final List<VolumeStatusEvent> events;

    private final String volumeId;

    private final VolumeStatusInfo volumeStatus;

    private final List<VolumeStatusAttachmentStatus> attachmentStatuses;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.outpostArn = builder.outpostArn;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
        this.attachmentStatuses = builder.attachmentStatuses;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the operation.
     */
    public final List<VolumeStatusAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The Availability Zone of the volume.
     * </p>
     * 
     * @return The Availability Zone of the volume.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events associated with the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of events associated with the volume.
     */
    public final List<VolumeStatusEvent> events() {
        return events;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The volume status.
     * </p>
     * 
     * @return The volume status.
     */
    public final VolumeStatusInfo volumeStatus() {
        return volumeStatus;
    }

    /**
     * Returns true if the AttachmentStatuses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttachmentStatuses() {
        return attachmentStatuses != null && !(attachmentStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances to which the volume is attached.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachmentStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the instances to which the volume is attached.
     */
    public final List<VolumeStatusAttachmentStatus> attachmentStatuses() {
        return attachmentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachmentStatuses() ? attachmentStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(outpostArn(), other.outpostArn()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeStatus(), other.volumeStatus())
                && hasAttachmentStatuses() == other.hasAttachmentStatuses()
                && Objects.equals(attachmentStatuses(), other.attachmentStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeStatusItem").add("Actions", hasActions() ? actions() : null)
                .add("AvailabilityZone", availabilityZone()).add("OutpostArn", outpostArn())
                .add("Events", hasEvents() ? events() : null).add("VolumeId", volumeId()).add("VolumeStatus", volumeStatus())
                .add("AttachmentStatuses", hasAttachmentStatuses() ? attachmentStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeStatus":
            return Optional.ofNullable(clazz.cast(volumeStatus()));
        case "AttachmentStatuses":
            return Optional.ofNullable(clazz.cast(attachmentStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusItem, T> g) {
        return obj -> g.apply((VolumeStatusItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatusItem> {
        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<VolumeStatusAction> actions);

        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(VolumeStatusAction... actions);

        /**
         * <p>
         * The details of the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusAction>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeStatusAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusAction>.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(List<VolumeStatusAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<VolumeStatusAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<VolumeStatusAction>)
         */
        Builder actions(Consumer<VolumeStatusAction.Builder>... actions);

        /**
         * <p>
         * The Availability Zone of the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<VolumeStatusEvent> events);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(VolumeStatusEvent... events);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusEvent>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeStatusEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusEvent>.Builder#build()} is called immediately
         * and its result is passed to {@link #events(List<VolumeStatusEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<VolumeStatusEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<VolumeStatusEvent>)
         */
        Builder events(Consumer<VolumeStatusEvent.Builder>... events);

        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The volume status.
         * </p>
         * 
         * @param volumeStatus
         *        The volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatus(VolumeStatusInfo volumeStatus);

        /**
         * <p>
         * The volume status.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeStatusInfo.Builder} avoiding the need to
         * create one manually via {@link VolumeStatusInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeStatusInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeStatus(VolumeStatusInfo)}.
         * 
         * @param volumeStatus
         *        a consumer that will call methods on {@link VolumeStatusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatus(VolumeStatusInfo)
         */
        default Builder volumeStatus(Consumer<VolumeStatusInfo.Builder> volumeStatus) {
            return volumeStatus(VolumeStatusInfo.builder().applyMutation(volumeStatus).build());
        }

        /**
         * <p>
         * Information about the instances to which the volume is attached.
         * </p>
         * 
         * @param attachmentStatuses
         *        Information about the instances to which the volume is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentStatuses(Collection<VolumeStatusAttachmentStatus> attachmentStatuses);

        /**
         * <p>
         * Information about the instances to which the volume is attached.
         * </p>
         * 
         * @param attachmentStatuses
         *        Information about the instances to which the volume is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentStatuses(VolumeStatusAttachmentStatus... attachmentStatuses);

        /**
         * <p>
         * Information about the instances to which the volume is attached.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusAttachmentStatus>.Builder}
         * avoiding the need to create one manually via {@link List<VolumeStatusAttachmentStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusAttachmentStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachmentStatuses(List<VolumeStatusAttachmentStatus>)}.
         * 
         * @param attachmentStatuses
         *        a consumer that will call methods on {@link List<VolumeStatusAttachmentStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentStatuses(List<VolumeStatusAttachmentStatus>)
         */
        Builder attachmentStatuses(Consumer<VolumeStatusAttachmentStatus.Builder>... attachmentStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeStatusAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String outpostArn;

        private List<VolumeStatusEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String volumeId;

        private VolumeStatusInfo volumeStatus;

        private List<VolumeStatusAttachmentStatus> attachmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            actions(model.actions);
            availabilityZone(model.availabilityZone);
            outpostArn(model.outpostArn);
            events(model.events);
            volumeId(model.volumeId);
            volumeStatus(model.volumeStatus);
            attachmentStatuses(model.attachmentStatuses);
        }

        public final List<VolumeStatusAction.Builder> getActions() {
            List<VolumeStatusAction.Builder> result = VolumeStatusActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VolumeStatusAction.BuilderImpl> actions) {
            this.actions = VolumeStatusActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(VolumeStatusAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<VolumeStatusAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> VolumeStatusAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        @Transient
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final List<VolumeStatusEvent.Builder> getEvents() {
            List<VolumeStatusEvent.Builder> result = VolumeStatusEventsListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<VolumeStatusEvent.BuilderImpl> events) {
            this.events = VolumeStatusEventsListCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(VolumeStatusEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<VolumeStatusEvent.Builder>... events) {
            events(Stream.of(events).map(c -> VolumeStatusEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final VolumeStatusInfo.Builder getVolumeStatus() {
            return volumeStatus != null ? volumeStatus.toBuilder() : null;
        }

        public final void setVolumeStatus(VolumeStatusInfo.BuilderImpl volumeStatus) {
            this.volumeStatus = volumeStatus != null ? volumeStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final List<VolumeStatusAttachmentStatus.Builder> getAttachmentStatuses() {
            List<VolumeStatusAttachmentStatus.Builder> result = VolumeStatusAttachmentStatusListCopier
                    .copyToBuilder(this.attachmentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentStatuses(Collection<VolumeStatusAttachmentStatus.BuilderImpl> attachmentStatuses) {
            this.attachmentStatuses = VolumeStatusAttachmentStatusListCopier.copyFromBuilder(attachmentStatuses);
        }

        @Override
        @Transient
        public final Builder attachmentStatuses(Collection<VolumeStatusAttachmentStatus> attachmentStatuses) {
            this.attachmentStatuses = VolumeStatusAttachmentStatusListCopier.copy(attachmentStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachmentStatuses(VolumeStatusAttachmentStatus... attachmentStatuses) {
            attachmentStatuses(Arrays.asList(attachmentStatuses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachmentStatuses(Consumer<VolumeStatusAttachmentStatus.Builder>... attachmentStatuses) {
            attachmentStatuses(Stream.of(attachmentStatuses)
                    .map(c -> VolumeStatusAttachmentStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
