/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route for a transit gateway route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRoute.Builder, TransitGatewayRoute> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(TransitGatewayRoute::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(TransitGatewayRoute::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<List<TransitGatewayRouteAttachment>> TRANSIT_GATEWAY_ATTACHMENTS_FIELD = SdkField
            .<List<TransitGatewayRouteAttachment>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayAttachments")
            .getter(getter(TransitGatewayRoute::transitGatewayAttachments))
            .setter(setter(Builder::transitGatewayAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachments")
                    .unmarshallLocationName("transitGatewayAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayRouteAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayRouteAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(TransitGatewayRoute::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayRoute::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            PREFIX_LIST_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENTS_FIELD, TYPE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationCidrBlock;

    private final String prefixListId;

    private final List<TransitGatewayRouteAttachment> transitGatewayAttachments;

    private final String type;

    private final String state;

    private TransitGatewayRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.prefixListId = builder.prefixListId;
        this.transitGatewayAttachments = builder.transitGatewayAttachments;
        this.type = builder.type;
        this.state = builder.state;
    }

    /**
     * <p>
     * The CIDR block used for destination matches.
     * </p>
     * 
     * @return The CIDR block used for destination matches.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the prefix list used for destination matches.
     * </p>
     * 
     * @return The ID of the prefix list used for destination matches.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * Returns true if the TransitGatewayAttachments property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTransitGatewayAttachments() {
        return transitGatewayAttachments != null && !(transitGatewayAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransitGatewayAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attachments.
     */
    public final List<TransitGatewayRouteAttachment> transitGatewayAttachments() {
        return transitGatewayAttachments;
    }

    /**
     * <p>
     * The route type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TransitGatewayRouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The route type.
     * @see TransitGatewayRouteType
     */
    public final TransitGatewayRouteType type() {
        return TransitGatewayRouteType.fromValue(type);
    }

    /**
     * <p>
     * The route type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TransitGatewayRouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The route type.
     * @see TransitGatewayRouteType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The state of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route.
     * @see TransitGatewayRouteState
     */
    public final TransitGatewayRouteState state() {
        return TransitGatewayRouteState.fromValue(state);
    }

    /**
     * <p>
     * The state of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route.
     * @see TransitGatewayRouteState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayAttachments() ? transitGatewayAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRoute)) {
            return false;
        }
        TransitGatewayRoute other = (TransitGatewayRoute) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(prefixListId(), other.prefixListId())
                && hasTransitGatewayAttachments() == other.hasTransitGatewayAttachments()
                && Objects.equals(transitGatewayAttachments(), other.transitGatewayAttachments())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayRoute").add("DestinationCidrBlock", destinationCidrBlock())
                .add("PrefixListId", prefixListId())
                .add("TransitGatewayAttachments", hasTransitGatewayAttachments() ? transitGatewayAttachments() : null)
                .add("Type", typeAsString()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "TransitGatewayAttachments":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachments()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRoute, T> g) {
        return obj -> g.apply((TransitGatewayRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRoute> {
        /**
         * <p>
         * The CIDR block used for destination matches.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block used for destination matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the prefix list used for destination matches.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list used for destination matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param transitGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachments(Collection<TransitGatewayRouteAttachment> transitGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param transitGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachments(TransitGatewayRouteAttachment... transitGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransitGatewayRouteAttachment>.Builder}
         * avoiding the need to create one manually via {@link List<TransitGatewayRouteAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitGatewayRouteAttachment>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #transitGatewayAttachments(List<TransitGatewayRouteAttachment>)}.
         * 
         * @param transitGatewayAttachments
         *        a consumer that will call methods on {@link List<TransitGatewayRouteAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayAttachments(List<TransitGatewayRouteAttachment>)
         */
        Builder transitGatewayAttachments(Consumer<TransitGatewayRouteAttachment.Builder>... transitGatewayAttachments);

        /**
         * <p>
         * The route type.
         * </p>
         * 
         * @param type
         *        The route type.
         * @see TransitGatewayRouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteType
         */
        Builder type(String type);

        /**
         * <p>
         * The route type.
         * </p>
         * 
         * @param type
         *        The route type.
         * @see TransitGatewayRouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteType
         */
        Builder type(TransitGatewayRouteType type);

        /**
         * <p>
         * The state of the route.
         * </p>
         * 
         * @param state
         *        The state of the route.
         * @see TransitGatewayRouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the route.
         * </p>
         * 
         * @param state
         *        The state of the route.
         * @see TransitGatewayRouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteState
         */
        Builder state(TransitGatewayRouteState state);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String prefixListId;

        private List<TransitGatewayRouteAttachment> transitGatewayAttachments = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRoute model) {
            destinationCidrBlock(model.destinationCidrBlock);
            prefixListId(model.prefixListId);
            transitGatewayAttachments(model.transitGatewayAttachments);
            type(model.type);
            state(model.state);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        @Transient
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final List<TransitGatewayRouteAttachment.Builder> getTransitGatewayAttachments() {
            List<TransitGatewayRouteAttachment.Builder> result = TransitGatewayRouteAttachmentListCopier
                    .copyToBuilder(this.transitGatewayAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayAttachments(
                Collection<TransitGatewayRouteAttachment.BuilderImpl> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayRouteAttachmentListCopier.copyFromBuilder(transitGatewayAttachments);
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachments(Collection<TransitGatewayRouteAttachment> transitGatewayAttachments) {
            this.transitGatewayAttachments = TransitGatewayRouteAttachmentListCopier.copy(transitGatewayAttachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayAttachments(TransitGatewayRouteAttachment... transitGatewayAttachments) {
            transitGatewayAttachments(Arrays.asList(transitGatewayAttachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transitGatewayAttachments(
                Consumer<TransitGatewayRouteAttachment.Builder>... transitGatewayAttachments) {
            transitGatewayAttachments(Stream.of(transitGatewayAttachments)
                    .map(c -> TransitGatewayRouteAttachment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TransitGatewayRouteType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(TransitGatewayRouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public TransitGatewayRoute build() {
            return new TransitGatewayRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
