/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<StopInstancesResponse.Builder, StopInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STOPPING_INSTANCES_FIELD = SdkField
            .<List<InstanceStateChange>> builder(MarshallingType.LIST)
            .memberName("StoppingInstances")
            .getter(getter(StopInstancesResponse::stoppingInstances))
            .setter(setter(Builder::stoppingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOPPING_INSTANCES_FIELD));

    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.stoppingInstances = builder.stoppingInstances;
    }

    /**
     * Returns true if the StoppingInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStoppingInstances() {
        return stoppingInstances != null && !(stoppingInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stopped instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStoppingInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the stopped instances.
     */
    public final List<InstanceStateChange> stoppingInstances() {
        return stoppingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStoppingInstances() ? stoppingInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse) obj;
        return hasStoppingInstances() == other.hasStoppingInstances()
                && Objects.equals(stoppingInstances(), other.stoppingInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopInstancesResponse")
                .add("StoppingInstances", hasStoppingInstances() ? stoppingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoppingInstances":
            return Optional.ofNullable(clazz.cast(stoppingInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopInstancesResponse, T> g) {
        return obj -> g.apply((StopInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, StopInstancesResponse> {
        /**
         * <p>
         * Information about the stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about the stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances);

        /**
         * <p>
         * Information about the stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about the stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(InstanceStateChange... stoppingInstances);

        /**
         * <p>
         * Information about the stopped instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #stoppingInstances(List<InstanceStateChange>)}.
         * 
         * @param stoppingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingInstances(List<InstanceStateChange>)
         */
        Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> stoppingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            super(model);
            stoppingInstances(model.stoppingInstances);
        }

        public final List<InstanceStateChange.Builder> getStoppingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.stoppingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        @Transient
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange... stoppingInstances) {
            stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances) {
            stoppingInstances(Stream.of(stoppingInstances).map(c -> InstanceStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
