/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSpotLaunchSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestSpotLaunchSpecification.Builder, RequestSpotLaunchSpecification> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(RequestSpotLaunchSpecification::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(RequestSpotLaunchSpecification::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup")
                    .unmarshallLocationName("SecurityGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ADDRESSING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AddressingType")
            .getter(getter(RequestSpotLaunchSpecification::addressingType))
            .setter(setter(Builder::addressingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressingType")
                    .unmarshallLocationName("addressingType").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(RequestSpotLaunchSpecification::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(RequestSpotLaunchSpecification::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfileSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(RequestSpotLaunchSpecification::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfileSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(RequestSpotLaunchSpecification::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(RequestSpotLaunchSpecification::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(RequestSpotLaunchSpecification::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(RequestSpotLaunchSpecification::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField
            .<RunInstancesMonitoringEnabled> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(RequestSpotLaunchSpecification::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(RunInstancesMonitoringEnabled::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("monitoring").build()).build();

    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterfaceSpecification>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(RequestSpotLaunchSpecification::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("NetworkInterface").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterfaceSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterfaceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<SpotPlacement> PLACEMENT_FIELD = SdkField
            .<SpotPlacement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(RequestSpotLaunchSpecification::placement))
            .setter(setter(Builder::placement))
            .constructor(SpotPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(RequestSpotLaunchSpecification::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(RequestSpotLaunchSpecification::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(RequestSpotLaunchSpecification::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("userData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD,
            SECURITY_GROUPS_FIELD, ADDRESSING_TYPE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, EBS_OPTIMIZED_FIELD,
            IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, MONITORING_FIELD,
            NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final String addressingType;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final RunInstancesMonitoringEnabled monitoring;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final SpotPlacement placement;

    private final String ramdiskId;

    private final String subnetId;

    private final String userData;

    private RequestSpotLaunchSpecification(BuilderImpl builder) {
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more security group IDs.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups.
     * When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
     *         groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
     *         groups.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final String addressingType() {
        return addressingType;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This is
     * because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank
     * and its encryption status is used for the volume encryption status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value.
     *         This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume,
     *         it is not blank and its encryption status is used for the volume encryption status.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput
     *         to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Indicates whether basic or detailed monitoring is enabled for the instance.
     * </p>
     * <p>
     * Default: Disabled
     * </p>
     * 
     * @return Indicates whether basic or detailed monitoring is enabled for the instance.</p>
     *         <p>
     *         Default: Disabled
     */
    public final RunInstancesMonitoringEnabled monitoring() {
        return monitoring;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
     * group IDs using the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
     *         security group IDs using the network interface.
     */
    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information for the instance.
     * </p>
     * 
     * @return The placement information for the instance.
     */
    public final SpotPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instance.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Base64-encoded user data for the instance. User data is limited to 16 KB.
     * </p>
     * 
     * @return The Base64-encoded user data for the instance. User data is limited to 16 KB.
     */
    public final String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotLaunchSpecification)) {
            return false;
        }
        RequestSpotLaunchSpecification other = (RequestSpotLaunchSpecification) obj;
        return hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(addressingType(), other.addressingType())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(monitoring(), other.monitoring()) && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(userData(), other.userData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestSpotLaunchSpecification")
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("AddressingType", addressingType())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("EbsOptimized", ebsOptimized()).add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("Monitoring", monitoring()).add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("Placement", placement()).add("RamdiskId", ramdiskId()).add("SubnetId", subnetId())
                .add("UserData", userData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "AddressingType":
            return Optional.ofNullable(clazz.cast(addressingType()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotLaunchSpecification, T> g) {
        return obj -> g.apply((RequestSpotLaunchSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestSpotLaunchSpecification> {
        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security
         * groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security
         * groups.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups. When requesting instances in a VPC, you must specify the IDs of the
         *        security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the
         *        security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param addressingType
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressingType(String addressingType);

        /**
         * <p>
         * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This
         * is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is
         * not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries. You can't specify both a snapshot ID and an encryption
         *        value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for
         *        a volume, it is not blank and its encryption status is used for the volume encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This
         * is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is
         * not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries. You can't specify both a snapshot ID and an encryption
         *        value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for
         *        a volume, it is not blank and its encryption status is used for the volume encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This
         * is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is
         * not blank and its encryption status is used for the volume encryption status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS Optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Indicates whether basic or detailed monitoring is enabled for the instance.
         * </p>
         * <p>
         * Default: Disabled
         * </p>
         * 
         * @param monitoring
         *        Indicates whether basic or detailed monitoring is enabled for the instance.</p>
         *        <p>
         *        Default: Disabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(RunInstancesMonitoringEnabled monitoring);

        /**
         * <p>
         * Indicates whether basic or detailed monitoring is enabled for the instance.
         * </p>
         * <p>
         * Default: Disabled
         * </p>
         * This is a convenience that creates an instance of the {@link RunInstancesMonitoringEnabled.Builder} avoiding
         * the need to create one manually via {@link RunInstancesMonitoringEnabled#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunInstancesMonitoringEnabled.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(RunInstancesMonitoringEnabled)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link RunInstancesMonitoringEnabled.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(RunInstancesMonitoringEnabled)
         */
        default Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return monitoring(RunInstancesMonitoringEnabled.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify subnet IDs and
         *        security group IDs using the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security
         * group IDs using the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <InstanceNetworkInterfaceSpecification>.Builder} avoiding the need to create one manually via {@link List
         * <InstanceNetworkInterfaceSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceNetworkInterfaceSpecification>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<InstanceNetworkInterfaceSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * 
         * @param placement
         *        The placement information for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(SpotPlacement placement);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotPlacement.Builder} avoiding the need to
         * create one manually via {@link SpotPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotPlacement.Builder#build()} is called immediately and its
         * result is passed to {@link #placement(SpotPlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link SpotPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(SpotPlacement)
         */
        default Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return placement(SpotPlacement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The ID of the subnet in which to launch the instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Base64-encoded user data for the instance. User data is limited to 16 KB.
         * </p>
         * 
         * @param userData
         *        The Base64-encoded user data for the instance. User data is limited to 16 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String addressingType;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private RunInstancesMonitoringEnabled monitoring;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private SpotPlacement placement;

        private String ramdiskId;

        private String subnetId;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotLaunchSpecification model) {
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            addressingType(model.addressingType);
            blockDeviceMappings(model.blockDeviceMappings);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            subnetId(model.subnetId);
            userData(model.userData);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = RequestSpotLaunchSpecificationSecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = RequestSpotLaunchSpecificationSecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = RequestSpotLaunchSpecificationSecurityGroupListCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = RequestSpotLaunchSpecificationSecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getAddressingType() {
            return addressingType;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        @Override
        @Transient
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        @Transient
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        @Transient
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        @Transient
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        @Transient
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = InstanceNetworkInterfaceSpecificationListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        @Transient
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> InstanceNetworkInterfaceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SpotPlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        @Transient
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        @Transient
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        @Transient
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        @Override
        public RequestSpotLaunchSpecification build() {
            return new RequestSpotLaunchSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
