/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportImageTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImportImageTasksResponse.Builder, DescribeImportImageTasksResponse> {
    private static final SdkField<List<ImportImageTask>> IMPORT_IMAGE_TASKS_FIELD = SdkField
            .<List<ImportImageTask>> builder(MarshallingType.LIST)
            .memberName("ImportImageTasks")
            .getter(getter(DescribeImportImageTasksResponse::importImageTasks))
            .setter(setter(Builder::importImageTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportImageTaskSet")
                    .unmarshallLocationName("importImageTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportImageTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportImageTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeImportImageTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_IMAGE_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImportImageTask> importImageTasks;

    private final String nextToken;

    private DescribeImportImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importImageTasks = builder.importImageTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ImportImageTasks property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasImportImageTasks() {
        return importImageTasks != null && !(importImageTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of zero or more import image tasks that are currently active or were completed or canceled in the previous
     * 7 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImportImageTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of zero or more import image tasks that are currently active or were completed or canceled in the
     *         previous 7 days.
     */
    public final List<ImportImageTask> importImageTasks() {
        return importImageTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportImageTasks() ? importImageTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportImageTasksResponse)) {
            return false;
        }
        DescribeImportImageTasksResponse other = (DescribeImportImageTasksResponse) obj;
        return hasImportImageTasks() == other.hasImportImageTasks()
                && Objects.equals(importImageTasks(), other.importImageTasks()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImportImageTasksResponse")
                .add("ImportImageTasks", hasImportImageTasks() ? importImageTasks() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportImageTasks":
            return Optional.ofNullable(clazz.cast(importImageTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportImageTasksResponse, T> g) {
        return obj -> g.apply((DescribeImportImageTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImportImageTasksResponse> {
        /**
         * <p>
         * A list of zero or more import image tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importImageTasks
         *        A list of zero or more import image tasks that are currently active or were completed or canceled in
         *        the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importImageTasks(Collection<ImportImageTask> importImageTasks);

        /**
         * <p>
         * A list of zero or more import image tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importImageTasks
         *        A list of zero or more import image tasks that are currently active or were completed or canceled in
         *        the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importImageTasks(ImportImageTask... importImageTasks);

        /**
         * <p>
         * A list of zero or more import image tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportImageTask>.Builder} avoiding the need
         * to create one manually via {@link List<ImportImageTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportImageTask>.Builder#build()} is called immediately and
         * its result is passed to {@link #importImageTasks(List<ImportImageTask>)}.
         * 
         * @param importImageTasks
         *        a consumer that will call methods on {@link List<ImportImageTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importImageTasks(List<ImportImageTask>)
         */
        Builder importImageTasks(Consumer<ImportImageTask.Builder>... importImageTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ImportImageTask> importImageTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportImageTasksResponse model) {
            super(model);
            importImageTasks(model.importImageTasks);
            nextToken(model.nextToken);
        }

        public final List<ImportImageTask.Builder> getImportImageTasks() {
            List<ImportImageTask.Builder> result = ImportImageTaskListCopier.copyToBuilder(this.importImageTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportImageTasks(Collection<ImportImageTask.BuilderImpl> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copyFromBuilder(importImageTasks);
        }

        @Override
        @Transient
        public final Builder importImageTasks(Collection<ImportImageTask> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copy(importImageTasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder importImageTasks(ImportImageTask... importImageTasks) {
            importImageTasks(Arrays.asList(importImageTasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder importImageTasks(Consumer<ImportImageTask.Builder>... importImageTasks) {
            importImageTasks(Stream.of(importImageTasks).map(c -> ImportImageTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImportImageTasksResponse build() {
            return new DescribeImportImageTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
