/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a client connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpnConnection.Builder, ClientVpnConnection> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(ClientVpnConnection::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("clientVpnEndpointId").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Timestamp")
            .getter(getter(ClientVpnConnection::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp")
                    .unmarshallLocationName("timestamp").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId")
            .getter(getter(ClientVpnConnection::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId")
                    .unmarshallLocationName("connectionId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Username")
            .getter(getter(ClientVpnConnection::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username")
                    .unmarshallLocationName("username").build()).build();

    private static final SdkField<String> CONNECTION_ESTABLISHED_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionEstablishedTime")
            .getter(getter(ClientVpnConnection::connectionEstablishedTime))
            .setter(setter(Builder::connectionEstablishedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEstablishedTime")
                    .unmarshallLocationName("connectionEstablishedTime").build()).build();

    private static final SdkField<String> INGRESS_BYTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IngressBytes")
            .getter(getter(ClientVpnConnection::ingressBytes))
            .setter(setter(Builder::ingressBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressBytes")
                    .unmarshallLocationName("ingressBytes").build()).build();

    private static final SdkField<String> EGRESS_BYTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressBytes")
            .getter(getter(ClientVpnConnection::egressBytes))
            .setter(setter(Builder::egressBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressBytes")
                    .unmarshallLocationName("egressBytes").build()).build();

    private static final SdkField<String> INGRESS_PACKETS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IngressPackets")
            .getter(getter(ClientVpnConnection::ingressPackets))
            .setter(setter(Builder::ingressPackets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPackets")
                    .unmarshallLocationName("ingressPackets").build()).build();

    private static final SdkField<String> EGRESS_PACKETS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressPackets")
            .getter(getter(ClientVpnConnection::egressPackets))
            .setter(setter(Builder::egressPackets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressPackets")
                    .unmarshallLocationName("egressPackets").build()).build();

    private static final SdkField<String> CLIENT_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientIp")
            .getter(getter(ClientVpnConnection::clientIp))
            .setter(setter(Builder::clientIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIp")
                    .unmarshallLocationName("clientIp").build()).build();

    private static final SdkField<String> COMMON_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CommonName")
            .getter(getter(ClientVpnConnection::commonName))
            .setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName")
                    .unmarshallLocationName("commonName").build()).build();

    private static final SdkField<ClientVpnConnectionStatus> STATUS_FIELD = SdkField
            .<ClientVpnConnectionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(ClientVpnConnection::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> CONNECTION_END_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionEndTime")
            .getter(getter(ClientVpnConnection::connectionEndTime))
            .setter(setter(Builder::connectionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEndTime")
                    .unmarshallLocationName("connectionEndTime").build()).build();

    private static final SdkField<List<String>> POSTURE_COMPLIANCE_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PostureComplianceStatuses")
            .getter(getter(ClientVpnConnection::postureComplianceStatuses))
            .setter(setter(Builder::postureComplianceStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostureComplianceStatusSet")
                    .unmarshallLocationName("postureComplianceStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            TIMESTAMP_FIELD, CONNECTION_ID_FIELD, USERNAME_FIELD, CONNECTION_ESTABLISHED_TIME_FIELD, INGRESS_BYTES_FIELD,
            EGRESS_BYTES_FIELD, INGRESS_PACKETS_FIELD, EGRESS_PACKETS_FIELD, CLIENT_IP_FIELD, COMMON_NAME_FIELD, STATUS_FIELD,
            CONNECTION_END_TIME_FIELD, POSTURE_COMPLIANCE_STATUSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientVpnEndpointId;

    private final String timestamp;

    private final String connectionId;

    private final String username;

    private final String connectionEstablishedTime;

    private final String ingressBytes;

    private final String egressBytes;

    private final String ingressPackets;

    private final String egressPackets;

    private final String clientIp;

    private final String commonName;

    private final ClientVpnConnectionStatus status;

    private final String connectionEndTime;

    private final List<String> postureComplianceStatuses;

    private ClientVpnConnection(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.timestamp = builder.timestamp;
        this.connectionId = builder.connectionId;
        this.username = builder.username;
        this.connectionEstablishedTime = builder.connectionEstablishedTime;
        this.ingressBytes = builder.ingressBytes;
        this.egressBytes = builder.egressBytes;
        this.ingressPackets = builder.ingressPackets;
        this.egressPackets = builder.egressPackets;
        this.clientIp = builder.clientIp;
        this.commonName = builder.commonName;
        this.status = builder.status;
        this.connectionEndTime = builder.connectionEndTime;
        this.postureComplianceStatuses = builder.postureComplianceStatuses;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint to which the client is connected.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint to which the client is connected.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The current date and time.
     * </p>
     * 
     * @return The current date and time.
     */
    public final String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The ID of the client connection.
     * </p>
     * 
     * @return The ID of the client connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The username of the client who established the client connection. This information is only provided if Active
     * Directory client authentication is used.
     * </p>
     * 
     * @return The username of the client who established the client connection. This information is only provided if
     *         Active Directory client authentication is used.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The date and time the client connection was established.
     * </p>
     * 
     * @return The date and time the client connection was established.
     */
    public final String connectionEstablishedTime() {
        return connectionEstablishedTime;
    }

    /**
     * <p>
     * The number of bytes sent by the client.
     * </p>
     * 
     * @return The number of bytes sent by the client.
     */
    public final String ingressBytes() {
        return ingressBytes;
    }

    /**
     * <p>
     * The number of bytes received by the client.
     * </p>
     * 
     * @return The number of bytes received by the client.
     */
    public final String egressBytes() {
        return egressBytes;
    }

    /**
     * <p>
     * The number of packets sent by the client.
     * </p>
     * 
     * @return The number of packets sent by the client.
     */
    public final String ingressPackets() {
        return ingressPackets;
    }

    /**
     * <p>
     * The number of packets received by the client.
     * </p>
     * 
     * @return The number of packets received by the client.
     */
    public final String egressPackets() {
        return egressPackets;
    }

    /**
     * <p>
     * The IP address of the client.
     * </p>
     * 
     * @return The IP address of the client.
     */
    public final String clientIp() {
        return clientIp;
    }

    /**
     * <p>
     * The common name associated with the client. This is either the name of the client certificate, or the Active
     * Directory user name.
     * </p>
     * 
     * @return The common name associated with the client. This is either the name of the client certificate, or the
     *         Active Directory user name.
     */
    public final String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The current state of the client connection.
     * </p>
     * 
     * @return The current state of the client connection.
     */
    public final ClientVpnConnectionStatus status() {
        return status;
    }

    /**
     * <p>
     * The date and time the client connection was terminated.
     * </p>
     * 
     * @return The date and time the client connection was terminated.
     */
    public final String connectionEndTime() {
        return connectionEndTime;
    }

    /**
     * Returns true if the PostureComplianceStatuses property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPostureComplianceStatuses() {
        return postureComplianceStatuses != null && !(postureComplianceStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The statuses returned by the client connect handler for posture compliance, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPostureComplianceStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The statuses returned by the client connect handler for posture compliance, if applicable.
     */
    public final List<String> postureComplianceStatuses() {
        return postureComplianceStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(connectionEstablishedTime());
        hashCode = 31 * hashCode + Objects.hashCode(ingressBytes());
        hashCode = 31 * hashCode + Objects.hashCode(egressBytes());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPackets());
        hashCode = 31 * hashCode + Objects.hashCode(egressPackets());
        hashCode = 31 * hashCode + Objects.hashCode(clientIp());
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(connectionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasPostureComplianceStatuses() ? postureComplianceStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnConnection)) {
            return false;
        }
        ClientVpnConnection other = (ClientVpnConnection) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(username(), other.username())
                && Objects.equals(connectionEstablishedTime(), other.connectionEstablishedTime())
                && Objects.equals(ingressBytes(), other.ingressBytes()) && Objects.equals(egressBytes(), other.egressBytes())
                && Objects.equals(ingressPackets(), other.ingressPackets())
                && Objects.equals(egressPackets(), other.egressPackets()) && Objects.equals(clientIp(), other.clientIp())
                && Objects.equals(commonName(), other.commonName()) && Objects.equals(status(), other.status())
                && Objects.equals(connectionEndTime(), other.connectionEndTime())
                && hasPostureComplianceStatuses() == other.hasPostureComplianceStatuses()
                && Objects.equals(postureComplianceStatuses(), other.postureComplianceStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientVpnConnection").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("Timestamp", timestamp()).add("ConnectionId", connectionId()).add("Username", username())
                .add("ConnectionEstablishedTime", connectionEstablishedTime()).add("IngressBytes", ingressBytes())
                .add("EgressBytes", egressBytes()).add("IngressPackets", ingressPackets()).add("EgressPackets", egressPackets())
                .add("ClientIp", clientIp()).add("CommonName", commonName()).add("Status", status())
                .add("ConnectionEndTime", connectionEndTime())
                .add("PostureComplianceStatuses", hasPostureComplianceStatuses() ? postureComplianceStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "ConnectionEstablishedTime":
            return Optional.ofNullable(clazz.cast(connectionEstablishedTime()));
        case "IngressBytes":
            return Optional.ofNullable(clazz.cast(ingressBytes()));
        case "EgressBytes":
            return Optional.ofNullable(clazz.cast(egressBytes()));
        case "IngressPackets":
            return Optional.ofNullable(clazz.cast(ingressPackets()));
        case "EgressPackets":
            return Optional.ofNullable(clazz.cast(egressPackets()));
        case "ClientIp":
            return Optional.ofNullable(clazz.cast(clientIp()));
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ConnectionEndTime":
            return Optional.ofNullable(clazz.cast(connectionEndTime()));
        case "PostureComplianceStatuses":
            return Optional.ofNullable(clazz.cast(postureComplianceStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnConnection, T> g) {
        return obj -> g.apply((ClientVpnConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnConnection> {
        /**
         * <p>
         * The ID of the Client VPN endpoint to which the client is connected.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint to which the client is connected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The current date and time.
         * </p>
         * 
         * @param timestamp
         *        The current date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The ID of the client connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the client connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The username of the client who established the client connection. This information is only provided if Active
         * Directory client authentication is used.
         * </p>
         * 
         * @param username
         *        The username of the client who established the client connection. This information is only provided if
         *        Active Directory client authentication is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The date and time the client connection was established.
         * </p>
         * 
         * @param connectionEstablishedTime
         *        The date and time the client connection was established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEstablishedTime(String connectionEstablishedTime);

        /**
         * <p>
         * The number of bytes sent by the client.
         * </p>
         * 
         * @param ingressBytes
         *        The number of bytes sent by the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressBytes(String ingressBytes);

        /**
         * <p>
         * The number of bytes received by the client.
         * </p>
         * 
         * @param egressBytes
         *        The number of bytes received by the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressBytes(String egressBytes);

        /**
         * <p>
         * The number of packets sent by the client.
         * </p>
         * 
         * @param ingressPackets
         *        The number of packets sent by the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPackets(String ingressPackets);

        /**
         * <p>
         * The number of packets received by the client.
         * </p>
         * 
         * @param egressPackets
         *        The number of packets received by the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressPackets(String egressPackets);

        /**
         * <p>
         * The IP address of the client.
         * </p>
         * 
         * @param clientIp
         *        The IP address of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIp(String clientIp);

        /**
         * <p>
         * The common name associated with the client. This is either the name of the client certificate, or the Active
         * Directory user name.
         * </p>
         * 
         * @param commonName
         *        The common name associated with the client. This is either the name of the client certificate, or the
         *        Active Directory user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The current state of the client connection.
         * </p>
         * 
         * @param status
         *        The current state of the client connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnConnectionStatus status);

        /**
         * <p>
         * The current state of the client connection.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnConnectionStatus.Builder} avoiding the
         * need to create one manually via {@link ClientVpnConnectionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #status(ClientVpnConnectionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnConnectionStatus)
         */
        default Builder status(Consumer<ClientVpnConnectionStatus.Builder> status) {
            return status(ClientVpnConnectionStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The date and time the client connection was terminated.
         * </p>
         * 
         * @param connectionEndTime
         *        The date and time the client connection was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEndTime(String connectionEndTime);

        /**
         * <p>
         * The statuses returned by the client connect handler for posture compliance, if applicable.
         * </p>
         * 
         * @param postureComplianceStatuses
         *        The statuses returned by the client connect handler for posture compliance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postureComplianceStatuses(Collection<String> postureComplianceStatuses);

        /**
         * <p>
         * The statuses returned by the client connect handler for posture compliance, if applicable.
         * </p>
         * 
         * @param postureComplianceStatuses
         *        The statuses returned by the client connect handler for posture compliance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postureComplianceStatuses(String... postureComplianceStatuses);
    }

    static final class BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String timestamp;

        private String connectionId;

        private String username;

        private String connectionEstablishedTime;

        private String ingressBytes;

        private String egressBytes;

        private String ingressPackets;

        private String egressPackets;

        private String clientIp;

        private String commonName;

        private ClientVpnConnectionStatus status;

        private String connectionEndTime;

        private List<String> postureComplianceStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnConnection model) {
            clientVpnEndpointId(model.clientVpnEndpointId);
            timestamp(model.timestamp);
            connectionId(model.connectionId);
            username(model.username);
            connectionEstablishedTime(model.connectionEstablishedTime);
            ingressBytes(model.ingressBytes);
            egressBytes(model.egressBytes);
            ingressPackets(model.ingressPackets);
            egressPackets(model.egressPackets);
            clientIp(model.clientIp);
            commonName(model.commonName);
            status(model.status);
            connectionEndTime(model.connectionEndTime);
            postureComplianceStatuses(model.postureComplianceStatuses);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        @Transient
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getConnectionEstablishedTime() {
            return connectionEstablishedTime;
        }

        public final void setConnectionEstablishedTime(String connectionEstablishedTime) {
            this.connectionEstablishedTime = connectionEstablishedTime;
        }

        @Override
        @Transient
        public final Builder connectionEstablishedTime(String connectionEstablishedTime) {
            this.connectionEstablishedTime = connectionEstablishedTime;
            return this;
        }

        public final String getIngressBytes() {
            return ingressBytes;
        }

        public final void setIngressBytes(String ingressBytes) {
            this.ingressBytes = ingressBytes;
        }

        @Override
        @Transient
        public final Builder ingressBytes(String ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public final String getEgressBytes() {
            return egressBytes;
        }

        public final void setEgressBytes(String egressBytes) {
            this.egressBytes = egressBytes;
        }

        @Override
        @Transient
        public final Builder egressBytes(String egressBytes) {
            this.egressBytes = egressBytes;
            return this;
        }

        public final String getIngressPackets() {
            return ingressPackets;
        }

        public final void setIngressPackets(String ingressPackets) {
            this.ingressPackets = ingressPackets;
        }

        @Override
        @Transient
        public final Builder ingressPackets(String ingressPackets) {
            this.ingressPackets = ingressPackets;
            return this;
        }

        public final String getEgressPackets() {
            return egressPackets;
        }

        public final void setEgressPackets(String egressPackets) {
            this.egressPackets = egressPackets;
        }

        @Override
        @Transient
        public final Builder egressPackets(String egressPackets) {
            this.egressPackets = egressPackets;
            return this;
        }

        public final String getClientIp() {
            return clientIp;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        @Override
        @Transient
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public final String getCommonName() {
            return commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        @Transient
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final ClientVpnConnectionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnConnectionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(ClientVpnConnectionStatus status) {
            this.status = status;
            return this;
        }

        public final String getConnectionEndTime() {
            return connectionEndTime;
        }

        public final void setConnectionEndTime(String connectionEndTime) {
            this.connectionEndTime = connectionEndTime;
        }

        @Override
        @Transient
        public final Builder connectionEndTime(String connectionEndTime) {
            this.connectionEndTime = connectionEndTime;
            return this;
        }

        public final Collection<String> getPostureComplianceStatuses() {
            if (postureComplianceStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return postureComplianceStatuses;
        }

        public final void setPostureComplianceStatuses(Collection<String> postureComplianceStatuses) {
            this.postureComplianceStatuses = ValueStringListCopier.copy(postureComplianceStatuses);
        }

        @Override
        @Transient
        public final Builder postureComplianceStatuses(Collection<String> postureComplianceStatuses) {
            this.postureComplianceStatuses = ValueStringListCopier.copy(postureComplianceStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder postureComplianceStatuses(String... postureComplianceStatuses) {
            postureComplianceStatuses(Arrays.asList(postureComplianceStatuses));
            return this;
        }

        @Override
        public ClientVpnConnection build() {
            return new ClientVpnConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
