/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a snapshot that is currently in the Recycle Bin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotRecycleBinInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotRecycleBinInfo.Builder, SnapshotRecycleBinInfo> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(SnapshotRecycleBinInfo::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_ENTER_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinEnterTime")
            .getter(getter(SnapshotRecycleBinInfo::recycleBinEnterTime))
            .setter(setter(Builder::recycleBinEnterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinEnterTime")
                    .unmarshallLocationName("recycleBinEnterTime").build()).build();

    private static final SdkField<Instant> RECYCLE_BIN_EXIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecycleBinExitTime")
            .getter(getter(SnapshotRecycleBinInfo::recycleBinExitTime))
            .setter(setter(Builder::recycleBinExitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinExitTime")
                    .unmarshallLocationName("recycleBinExitTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SnapshotRecycleBinInfo::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(SnapshotRecycleBinInfo::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            RECYCLE_BIN_ENTER_TIME_FIELD, RECYCLE_BIN_EXIT_TIME_FIELD, DESCRIPTION_FIELD, VOLUME_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final Instant recycleBinEnterTime;

    private final Instant recycleBinExitTime;

    private final String description;

    private final String volumeId;

    private SnapshotRecycleBinInfo(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.recycleBinEnterTime = builder.recycleBinEnterTime;
        this.recycleBinExitTime = builder.recycleBinExitTime;
        this.description = builder.description;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The date and time when the snaphsot entered the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the snaphsot entered the Recycle Bin.
     */
    public final Instant recycleBinEnterTime() {
        return recycleBinEnterTime;
    }

    /**
     * <p>
     * The date and time when the snapshot is to be permanently deleted from the Recycle Bin.
     * </p>
     * 
     * @return The date and time when the snapshot is to be permanently deleted from the Recycle Bin.
     */
    public final Instant recycleBinExitTime() {
        return recycleBinExitTime;
    }

    /**
     * <p>
     * The description for the snapshot.
     * </p>
     * 
     * @return The description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the volume from which the snapshot was created.
     * </p>
     * 
     * @return The ID of the volume from which the snapshot was created.
     */
    public final String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinEnterTime());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinExitTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotRecycleBinInfo)) {
            return false;
        }
        SnapshotRecycleBinInfo other = (SnapshotRecycleBinInfo) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(recycleBinEnterTime(), other.recycleBinEnterTime())
                && Objects.equals(recycleBinExitTime(), other.recycleBinExitTime())
                && Objects.equals(description(), other.description()) && Objects.equals(volumeId(), other.volumeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotRecycleBinInfo").add("SnapshotId", snapshotId())
                .add("RecycleBinEnterTime", recycleBinEnterTime()).add("RecycleBinExitTime", recycleBinExitTime())
                .add("Description", description()).add("VolumeId", volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "RecycleBinEnterTime":
            return Optional.ofNullable(clazz.cast(recycleBinEnterTime()));
        case "RecycleBinExitTime":
            return Optional.ofNullable(clazz.cast(recycleBinExitTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotRecycleBinInfo, T> g) {
        return obj -> g.apply((SnapshotRecycleBinInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotRecycleBinInfo> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The date and time when the snaphsot entered the Recycle Bin.
         * </p>
         * 
         * @param recycleBinEnterTime
         *        The date and time when the snaphsot entered the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinEnterTime(Instant recycleBinEnterTime);

        /**
         * <p>
         * The date and time when the snapshot is to be permanently deleted from the Recycle Bin.
         * </p>
         * 
         * @param recycleBinExitTime
         *        The date and time when the snapshot is to be permanently deleted from the Recycle Bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinExitTime(Instant recycleBinExitTime);

        /**
         * <p>
         * The description for the snapshot.
         * </p>
         * 
         * @param description
         *        The description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the volume from which the snapshot was created.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume from which the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private Instant recycleBinEnterTime;

        private Instant recycleBinExitTime;

        private String description;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotRecycleBinInfo model) {
            snapshotId(model.snapshotId);
            recycleBinEnterTime(model.recycleBinEnterTime);
            recycleBinExitTime(model.recycleBinExitTime);
            description(model.description);
            volumeId(model.volumeId);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getRecycleBinEnterTime() {
            return recycleBinEnterTime;
        }

        public final void setRecycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
        }

        @Override
        @Transient
        public final Builder recycleBinEnterTime(Instant recycleBinEnterTime) {
            this.recycleBinEnterTime = recycleBinEnterTime;
            return this;
        }

        public final Instant getRecycleBinExitTime() {
            return recycleBinExitTime;
        }

        public final void setRecycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
        }

        @Override
        @Transient
        public final Builder recycleBinExitTime(Instant recycleBinExitTime) {
            this.recycleBinExitTime = recycleBinExitTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public SnapshotRecycleBinInfo build() {
            return new SnapshotRecycleBinInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
