/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for instance hostnames.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplatePrivateDnsNameOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplatePrivateDnsNameOptionsRequest.Builder, LaunchTemplatePrivateDnsNameOptionsRequest> {
    private static final SdkField<String> HOSTNAME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostnameType")
            .getter(getter(LaunchTemplatePrivateDnsNameOptionsRequest::hostnameTypeAsString))
            .setter(setter(Builder::hostnameType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameType")
                    .unmarshallLocationName("HostnameType").build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsARecord")
            .getter(getter(LaunchTemplatePrivateDnsNameOptionsRequest::enableResourceNameDnsARecord))
            .setter(setter(Builder::enableResourceNameDnsARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord")
                    .unmarshallLocationName("EnableResourceNameDnsARecord").build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsAAAARecord")
            .getter(getter(LaunchTemplatePrivateDnsNameOptionsRequest::enableResourceNameDnsAAAARecord))
            .setter(setter(Builder::enableResourceNameDnsAAAARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord")
                    .unmarshallLocationName("EnableResourceNameDnsAAAARecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_TYPE_FIELD,
            ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD, ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostnameType;

    private final Boolean enableResourceNameDnsARecord;

    private final Boolean enableResourceNameDnsAAAARecord;

    private LaunchTemplatePrivateDnsNameOptionsRequest(BuilderImpl builder) {
        this.hostnameType = builder.hostnameType;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
    }

    /**
     * <p>
     * The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
     * instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For
     * dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostnameType} will
     * return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostnameTypeAsString}.
     * </p>
     * 
     * @return The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based
     *         on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance
     *         ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the
     *         instance ID.
     * @see HostnameType
     */
    public final HostnameType hostnameType() {
        return HostnameType.fromValue(hostnameType);
    }

    /**
     * <p>
     * The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the
     * instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For
     * dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostnameType} will
     * return {@link HostnameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostnameTypeAsString}.
     * </p>
     * 
     * @return The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based
     *         on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance
     *         ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the
     *         instance ID.
     * @see HostnameType
     */
    public final String hostnameTypeAsString() {
        return hostnameType;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    public final Boolean enableResourceNameDnsARecord() {
        return enableResourceNameDnsARecord;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    public final Boolean enableResourceNameDnsAAAARecord() {
        return enableResourceNameDnsAAAARecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostnameTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsAAAARecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplatePrivateDnsNameOptionsRequest)) {
            return false;
        }
        LaunchTemplatePrivateDnsNameOptionsRequest other = (LaunchTemplatePrivateDnsNameOptionsRequest) obj;
        return Objects.equals(hostnameTypeAsString(), other.hostnameTypeAsString())
                && Objects.equals(enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord())
                && Objects.equals(enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplatePrivateDnsNameOptionsRequest").add("HostnameType", hostnameTypeAsString())
                .add("EnableResourceNameDnsARecord", enableResourceNameDnsARecord())
                .add("EnableResourceNameDnsAAAARecord", enableResourceNameDnsAAAARecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostnameType":
            return Optional.ofNullable(clazz.cast(hostnameTypeAsString()));
        case "EnableResourceNameDnsARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsARecord()));
        case "EnableResourceNameDnsAAAARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsAAAARecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplatePrivateDnsNameOptionsRequest, T> g) {
        return obj -> g.apply((LaunchTemplatePrivateDnsNameOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplatePrivateDnsNameOptionsRequest> {
        /**
         * <p>
         * The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on
         * the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID.
         * For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
         * </p>
         * 
         * @param hostnameType
         *        The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be
         *        based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the
         *        instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address
         *        or the instance ID.
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder hostnameType(String hostnameType);

        /**
         * <p>
         * The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on
         * the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID.
         * For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.
         * </p>
         * 
         * @param hostnameType
         *        The type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be
         *        based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the
         *        instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address
         *        or the instance ID.
         * @see HostnameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameType
         */
        Builder hostnameType(HostnameType hostnameType);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * 
         * @param enableResourceNameDnsARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * 
         * @param enableResourceNameDnsAAAARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord);
    }

    static final class BuilderImpl implements Builder {
        private String hostnameType;

        private Boolean enableResourceNameDnsARecord;

        private Boolean enableResourceNameDnsAAAARecord;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplatePrivateDnsNameOptionsRequest model) {
            hostnameType(model.hostnameType);
            enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
        }

        public final String getHostnameType() {
            return hostnameType;
        }

        public final void setHostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
        }

        @Override
        @Transient
        public final Builder hostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
            return this;
        }

        @Override
        @Transient
        public final Builder hostnameType(HostnameType hostnameType) {
            this.hostnameType(hostnameType == null ? null : hostnameType.toString());
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        @Transient
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        @Transient
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        @Override
        public LaunchTemplatePrivateDnsNameOptionsRequest build() {
            return new LaunchTemplatePrivateDnsNameOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
