/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplate implements SdkPojo, Serializable, ToCopyableBuilder<LaunchTemplate.Builder, LaunchTemplate> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LaunchTemplateId")
            .getter(getter(LaunchTemplate::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("launchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LaunchTemplateName")
            .getter(getter(LaunchTemplate::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("launchTemplateName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(LaunchTemplate::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy")
            .getter(getter(LaunchTemplate::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy")
                    .unmarshallLocationName("createdBy").build()).build();

    private static final SdkField<Long> DEFAULT_VERSION_NUMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DefaultVersionNumber")
            .getter(getter(LaunchTemplate::defaultVersionNumber))
            .setter(setter(Builder::defaultVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionNumber")
                    .unmarshallLocationName("defaultVersionNumber").build()).build();

    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LatestVersionNumber")
            .getter(getter(LaunchTemplate::latestVersionNumber))
            .setter(setter(Builder::latestVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber")
                    .unmarshallLocationName("latestVersionNumber").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LaunchTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, CREATE_TIME_FIELD, CREATED_BY_FIELD, DEFAULT_VERSION_NUMBER_FIELD,
            LATEST_VERSION_NUMBER_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final Instant createTime;

    private final String createdBy;

    private final Long defaultVersionNumber;

    private final Long latestVersionNumber;

    private final List<Tag> tags;

    private LaunchTemplate(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersionNumber = builder.defaultVersionNumber;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the launch template.
     * </p>
     * 
     * @return The ID of the launch template.
     */
    public final String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template.
     * </p>
     * 
     * @return The name of the launch template.
     */
    public final String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The time launch template was created.
     * </p>
     * 
     * @return The time launch template was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The principal that created the launch template.
     * </p>
     * 
     * @return The principal that created the launch template.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The version number of the default version of the launch template.
     * </p>
     * 
     * @return The version number of the default version of the launch template.
     */
    public final Long defaultVersionNumber() {
        return defaultVersionNumber;
    }

    /**
     * <p>
     * The version number of the latest version of the launch template.
     * </p>
     * 
     * @return The version number of the latest version of the launch template.
     */
    public final Long latestVersionNumber() {
        return latestVersionNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the launch template.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplate)) {
            return false;
        }
        LaunchTemplate other = (LaunchTemplate) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(defaultVersionNumber(), other.defaultVersionNumber())
                && Objects.equals(latestVersionNumber(), other.latestVersionNumber()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplate").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("CreateTime", createTime()).add("CreatedBy", createdBy())
                .add("DefaultVersionNumber", defaultVersionNumber()).add("LatestVersionNumber", latestVersionNumber())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "DefaultVersionNumber":
            return Optional.ofNullable(clazz.cast(defaultVersionNumber()));
        case "LatestVersionNumber":
            return Optional.ofNullable(clazz.cast(latestVersionNumber()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplate, T> g) {
        return obj -> g.apply((LaunchTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplate> {
        /**
         * <p>
         * The ID of the launch template.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The time launch template was created.
         * </p>
         * 
         * @param createTime
         *        The time launch template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The principal that created the launch template.
         * </p>
         * 
         * @param createdBy
         *        The principal that created the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The version number of the default version of the launch template.
         * </p>
         * 
         * @param defaultVersionNumber
         *        The version number of the default version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionNumber(Long defaultVersionNumber);

        /**
         * <p>
         * The version number of the latest version of the launch template.
         * </p>
         * 
         * @param latestVersionNumber
         *        The version number of the latest version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionNumber(Long latestVersionNumber);

        /**
         * <p>
         * The tags for the launch template.
         * </p>
         * 
         * @param tags
         *        The tags for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the launch template.
         * </p>
         * 
         * @param tags
         *        The tags for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private Instant createTime;

        private String createdBy;

        private Long defaultVersionNumber;

        private Long latestVersionNumber;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplate model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            createTime(model.createTime);
            createdBy(model.createdBy);
            defaultVersionNumber(model.defaultVersionNumber);
            latestVersionNumber(model.latestVersionNumber);
            tags(model.tags);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        @Transient
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        @Transient
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Long getDefaultVersionNumber() {
            return defaultVersionNumber;
        }

        public final void setDefaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
        }

        @Override
        @Transient
        public final Builder defaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
            return this;
        }

        public final Long getLatestVersionNumber() {
            return latestVersionNumber;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        @Transient
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LaunchTemplate build() {
            return new LaunchTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
