/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.ec2.model.VpcListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcsResponse> {
    private static final SdkField<List<Vpc>> VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vpcs").getter(DescribeVpcsResponse.getter(DescribeVpcsResponse::vpcs)).setter(DescribeVpcsResponse.setter(Builder::vpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSet").unmarshallLocationName("vpcSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Vpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcsResponse.getter(DescribeVpcsResponse::nextToken)).setter(DescribeVpcsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Vpc> vpcs;
    private final String nextToken;

    private DescribeVpcsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcs() {
        return this.vpcs != null && !(this.vpcs instanceof SdkAutoConstructList);
    }

    public final List<Vpc> vpcs() {
        return this.vpcs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcs() ? this.vpcs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcsResponse)) {
            return false;
        }
        DescribeVpcsResponse other = (DescribeVpcsResponse)((Object)obj);
        return this.hasVpcs() == other.hasVpcs() && Objects.equals(this.vpcs(), other.vpcs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcsResponse").add("Vpcs", this.hasVpcs() ? this.vpcs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpcs": {
                return Optional.ofNullable(clazz.cast(this.vpcs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcsResponse, T> g) {
        return obj -> g.apply((DescribeVpcsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Vpc> vpcs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcsResponse model) {
            super(model);
            this.vpcs(model.vpcs);
            this.nextToken(model.nextToken);
        }

        public final List<Vpc.Builder> getVpcs() {
            List<Vpc.Builder> result = VpcListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<Vpc.BuilderImpl> vpcs) {
            this.vpcs = VpcListCopier.copyFromBuilder(vpcs);
        }

        @Override
        @Transient
        public final Builder vpcs(Collection<Vpc> vpcs) {
            this.vpcs = VpcListCopier.copy(vpcs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(Vpc ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(Consumer<Vpc.Builder> ... vpcs) {
            this.vpcs(Stream.of(vpcs).map(c -> (Vpc)((Vpc.Builder)Vpc.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcsResponse build() {
            return new DescribeVpcsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcsResponse> {
        public Builder vpcs(Collection<Vpc> var1);

        public Builder vpcs(Vpc ... var1);

        public Builder vpcs(Consumer<Vpc.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

