/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot Fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotFleetRequestConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotFleetRequestConfig.Builder, SpotFleetRequestConfig> {
    private static final SdkField<String> ACTIVITY_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActivityStatus")
            .getter(getter(SpotFleetRequestConfig::activityStatusAsString))
            .setter(setter(Builder::activityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStatus")
                    .unmarshallLocationName("activityStatus").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(SpotFleetRequestConfig::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<SpotFleetRequestConfigData> SPOT_FLEET_REQUEST_CONFIG_FIELD = SdkField
            .<SpotFleetRequestConfigData> builder(MarshallingType.SDK_POJO)
            .memberName("SpotFleetRequestConfig")
            .getter(getter(SpotFleetRequestConfig::spotFleetRequestConfig))
            .setter(setter(Builder::spotFleetRequestConfig))
            .constructor(SpotFleetRequestConfigData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfig")
                    .unmarshallLocationName("spotFleetRequestConfig").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestId")
            .getter(getter(SpotFleetRequestConfig::spotFleetRequestId))
            .setter(setter(Builder::spotFleetRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build()).build();

    private static final SdkField<String> SPOT_FLEET_REQUEST_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotFleetRequestState")
            .getter(getter(SpotFleetRequestConfig::spotFleetRequestStateAsString))
            .setter(setter(Builder::spotFleetRequestState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestState")
                    .unmarshallLocationName("spotFleetRequestState").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SpotFleetRequestConfig::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_STATUS_FIELD,
            CREATE_TIME_FIELD, SPOT_FLEET_REQUEST_CONFIG_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, SPOT_FLEET_REQUEST_STATE_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activityStatus;

    private final Instant createTime;

    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private final String spotFleetRequestId;

    private final String spotFleetRequestState;

    private final List<Tag> tags;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
     * requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
     * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased,
     * the status is <code>pending_termination</code> while Spot Instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activityStatusAsString}.
     * </p>
     * 
     * @return The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
     *         requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to
     *         or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
     *         decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.
     * @see ActivityStatus
     */
    public final ActivityStatus activityStatus() {
        return ActivityStatus.fromValue(activityStatus);
    }

    /**
     * <p>
     * The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
     * requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
     * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased,
     * the status is <code>pending_termination</code> while Spot Instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activityStatusAsString}.
     * </p>
     * 
     * @return The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
     *         requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to
     *         or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
     *         decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.
     * @see ActivityStatus
     */
    public final String activityStatusAsString() {
        return activityStatus;
    }

    /**
     * <p>
     * The creation date and time of the request.
     * </p>
     * 
     * @return The creation date and time of the request.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The configuration of the Spot Fleet request.
     * </p>
     * 
     * @return The configuration of the Spot Fleet request.
     */
    public final SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    /**
     * <p>
     * The ID of the Spot Fleet request.
     * </p>
     * 
     * @return The ID of the Spot Fleet request.
     */
    public final String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #spotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The state of the Spot Fleet request.
     * @see BatchState
     */
    public final BatchState spotFleetRequestState() {
        return BatchState.fromValue(spotFleetRequestState);
    }

    /**
     * <p>
     * The state of the Spot Fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #spotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The state of the Spot Fleet request.
     * @see BatchState
     */
    public final String spotFleetRequestStateAsString() {
        return spotFleetRequestState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for a Spot Fleet resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for a Spot Fleet resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfig());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig) obj;
        return Objects.equals(activityStatusAsString(), other.activityStatusAsString())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(spotFleetRequestConfig(), other.spotFleetRequestConfig())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId())
                && Objects.equals(spotFleetRequestStateAsString(), other.spotFleetRequestStateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotFleetRequestConfig").add("ActivityStatus", activityStatusAsString())
                .add("CreateTime", createTime()).add("SpotFleetRequestConfig", spotFleetRequestConfig())
                .add("SpotFleetRequestId", spotFleetRequestId()).add("SpotFleetRequestState", spotFleetRequestStateAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityStatus":
            return Optional.ofNullable(clazz.cast(activityStatusAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "SpotFleetRequestConfig":
            return Optional.ofNullable(clazz.cast(spotFleetRequestConfig()));
        case "SpotFleetRequestId":
            return Optional.ofNullable(clazz.cast(spotFleetRequestId()));
        case "SpotFleetRequestState":
            return Optional.ofNullable(clazz.cast(spotFleetRequestStateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetRequestConfig, T> g) {
        return obj -> g.apply((SpotFleetRequestConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotFleetRequestConfig> {
        /**
         * <p>
         * The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
         * requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
         * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
         * decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After
         *        all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is
         *        equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the
         *        fleet is decreased, the status is <code>pending_termination</code> while Spot Instances are
         *        terminating.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder activityStatus(String activityStatus);

        /**
         * <p>
         * The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all
         * requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
         * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
         * decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After
         *        all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is
         *        equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the
         *        fleet is decreased, the status is <code>pending_termination</code> while Spot Instances are
         *        terminating.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder activityStatus(ActivityStatus activityStatus);

        /**
         * <p>
         * The creation date and time of the request.
         * </p>
         * 
         * @param createTime
         *        The creation date and time of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The configuration of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        The configuration of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);

        /**
         * <p>
         * The configuration of the Spot Fleet request.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotFleetRequestConfigData.Builder} avoiding the
         * need to create one manually via {@link SpotFleetRequestConfigData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotFleetRequestConfigData.Builder#build()} is called immediately
         * and its result is passed to {@link #spotFleetRequestConfig(SpotFleetRequestConfigData)}.
         * 
         * @param spotFleetRequestConfig
         *        a consumer that will call methods on {@link SpotFleetRequestConfigData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotFleetRequestConfig(SpotFleetRequestConfigData)
         */
        default Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return spotFleetRequestConfig(SpotFleetRequestConfigData.builder().applyMutation(spotFleetRequestConfig).build());
        }

        /**
         * <p>
         * The ID of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot Fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The state of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestState
         *        The state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder spotFleetRequestState(String spotFleetRequestState);

        /**
         * <p>
         * The state of the Spot Fleet request.
         * </p>
         * 
         * @param spotFleetRequestState
         *        The state of the Spot Fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder spotFleetRequestState(BatchState spotFleetRequestState);

        /**
         * <p>
         * The tags for a Spot Fleet resource.
         * </p>
         * 
         * @param tags
         *        The tags for a Spot Fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for a Spot Fleet resource.
         * </p>
         * 
         * @param tags
         *        The tags for a Spot Fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for a Spot Fleet resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String activityStatus;

        private Instant createTime;

        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private String spotFleetRequestId;

        private String spotFleetRequestState;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            activityStatus(model.activityStatus);
            createTime(model.createTime);
            spotFleetRequestConfig(model.spotFleetRequestConfig);
            spotFleetRequestId(model.spotFleetRequestId);
            spotFleetRequestState(model.spotFleetRequestState);
            tags(model.tags);
        }

        public final String getActivityStatus() {
            return activityStatus;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        @Override
        @Transient
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus == null ? null : activityStatus.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return spotFleetRequestConfig != null ? spotFleetRequestConfig.toBuilder() : null;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final String getSpotFleetRequestState() {
            return spotFleetRequestState;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState == null ? null : spotFleetRequestState.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
