/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionIpamPoolCidrRequest extends Ec2Request implements
        ToCopyableBuilder<ProvisionIpamPoolCidrRequest.Builder, ProvisionIpamPoolCidrRequest> {
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(ProvisionIpamPoolCidrRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(ProvisionIpamPoolCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<IpamCidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<IpamCidrAuthorizationContext> builder(MarshallingType.SDK_POJO)
            .memberName("CidrAuthorizationContext")
            .getter(getter(ProvisionIpamPoolCidrRequest::cidrAuthorizationContext))
            .setter(setter(Builder::cidrAuthorizationContext))
            .constructor(IpamCidrAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext")
                    .unmarshallLocationName("CidrAuthorizationContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ID_FIELD,
            CIDR_FIELD, CIDR_AUTHORIZATION_CONTEXT_FIELD));

    private final String ipamPoolId;

    private final String cidr;

    private final IpamCidrAuthorizationContext cidrAuthorizationContext;

    private ProvisionIpamPoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.ipamPoolId = builder.ipamPoolId;
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
    }

    /**
     * <p>
     * The ID of the IPAM pool to which you want to assign a CIDR.
     * </p>
     * 
     * @return The ID of the IPAM pool to which you want to assign a CIDR.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * The CIDR you want to assign to the IPAM pool.
     * </p>
     * 
     * @return The CIDR you want to assign to the IPAM pool.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
     * BYOIP. This option applies to public pools only.
     * </p>
     * 
     * @return A signed document that proves that you are authorized to bring a specified IP address range to Amazon
     *         using BYOIP. This option applies to public pools only.
     */
    public final IpamCidrAuthorizationContext cidrAuthorizationContext() {
        return cidrAuthorizationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAuthorizationContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamPoolCidrRequest)) {
            return false;
        }
        ProvisionIpamPoolCidrRequest other = (ProvisionIpamPoolCidrRequest) obj;
        return Objects.equals(ipamPoolId(), other.ipamPoolId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(cidrAuthorizationContext(), other.cidrAuthorizationContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionIpamPoolCidrRequest").add("IpamPoolId", ipamPoolId()).add("Cidr", cidr())
                .add("CidrAuthorizationContext", cidrAuthorizationContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CidrAuthorizationContext":
            return Optional.ofNullable(clazz.cast(cidrAuthorizationContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamPoolCidrRequest, T> g) {
        return obj -> g.apply((ProvisionIpamPoolCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionIpamPoolCidrRequest> {
        /**
         * <p>
         * The ID of the IPAM pool to which you want to assign a CIDR.
         * </p>
         * 
         * @param ipamPoolId
         *        The ID of the IPAM pool to which you want to assign a CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * The CIDR you want to assign to the IPAM pool.
         * </p>
         * 
         * @param cidr
         *        The CIDR you want to assign to the IPAM pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
         * BYOIP. This option applies to public pools only.
         * </p>
         * 
         * @param cidrAuthorizationContext
         *        A signed document that proves that you are authorized to bring a specified IP address range to Amazon
         *        using BYOIP. This option applies to public pools only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAuthorizationContext(IpamCidrAuthorizationContext cidrAuthorizationContext);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
         * BYOIP. This option applies to public pools only.
         * </p>
         * This is a convenience that creates an instance of the {@link IpamCidrAuthorizationContext.Builder} avoiding
         * the need to create one manually via {@link IpamCidrAuthorizationContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpamCidrAuthorizationContext.Builder#build()} is called
         * immediately and its result is passed to {@link #cidrAuthorizationContext(IpamCidrAuthorizationContext)}.
         * 
         * @param cidrAuthorizationContext
         *        a consumer that will call methods on {@link IpamCidrAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrAuthorizationContext(IpamCidrAuthorizationContext)
         */
        default Builder cidrAuthorizationContext(Consumer<IpamCidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return cidrAuthorizationContext(IpamCidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String ipamPoolId;

        private String cidr;

        private IpamCidrAuthorizationContext cidrAuthorizationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamPoolCidrRequest model) {
            super(model);
            ipamPoolId(model.ipamPoolId);
            cidr(model.cidr);
            cidrAuthorizationContext(model.cidrAuthorizationContext);
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        @Transient
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final IpamCidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return cidrAuthorizationContext != null ? cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(IpamCidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        @Transient
        public final Builder cidrAuthorizationContext(IpamCidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionIpamPoolCidrRequest build() {
            return new ProvisionIpamPoolCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
