/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Private DNS name for interface endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsDetails.Builder, PrivateDnsDetails> {
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(PrivateDnsDetails::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_DNS_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String privateDnsName;

    private PrivateDnsDetails(BuilderImpl builder) {
        this.privateDnsName = builder.privateDnsName;
    }

    /**
     * <p>
     * The private DNS name assigned to the VPC endpoint service.
     * </p>
     * 
     * @return The private DNS name assigned to the VPC endpoint service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsDetails)) {
            return false;
        }
        PrivateDnsDetails other = (PrivateDnsDetails) obj;
        return Objects.equals(privateDnsName(), other.privateDnsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsDetails").add("PrivateDnsName", privateDnsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsDetails, T> g) {
        return obj -> g.apply((PrivateDnsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsDetails> {
        /**
         * <p>
         * The private DNS name assigned to the VPC endpoint service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name assigned to the VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);
    }

    static final class BuilderImpl implements Builder {
        private String privateDnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsDetails model) {
            privateDnsName(model.privateDnsName);
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        @Override
        public PrivateDnsDetails build() {
            return new PrivateDnsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
