/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a local gateway route table and a virtual interface group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayRouteTableVirtualInterfaceGroupAssociation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder, LocalGatewayRouteTableVirtualInterfaceGroupAssociation> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .setter(setter(Builder::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId")
                    .unmarshallLocationName("localGatewayRouteTableVirtualInterfaceGroupAssociationId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceGroupId")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("localGatewayRouteTableId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableArn")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::localGatewayRouteTableArn))
            .setter(setter(Builder::localGatewayRouteTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableArn")
                    .unmarshallLocationName("localGatewayRouteTableArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD,
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD,
            LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD, OWNER_ID_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

    private final String localGatewayVirtualInterfaceGroupId;

    private final String localGatewayId;

    private final String localGatewayRouteTableId;

    private final String localGatewayRouteTableArn;

    private final String ownerId;

    private final String state;

    private final List<Tag> tags;

    private LocalGatewayRouteTableVirtualInterfaceGroupAssociation(BuilderImpl builder) {
        this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = builder.localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayId = builder.localGatewayId;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayRouteTableArn = builder.localGatewayRouteTableArn;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String localGatewayRouteTableVirtualInterfaceGroupAssociationId() {
        return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public final String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public final String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public final String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
     */
    public final String localGatewayRouteTableArn() {
        return localGatewayRouteTableArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the local gateway virtual interface group
     *         association.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * 
     * @return The state of the association.
     */
    public final String state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the association.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVirtualInterfaceGroupAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayRouteTableVirtualInterfaceGroupAssociation)) {
            return false;
        }
        LocalGatewayRouteTableVirtualInterfaceGroupAssociation other = (LocalGatewayRouteTableVirtualInterfaceGroupAssociation) obj;
        return Objects.equals(localGatewayRouteTableVirtualInterfaceGroupAssociationId(),
                other.localGatewayRouteTableVirtualInterfaceGroupAssociationId())
                && Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(localGatewayId(), other.localGatewayId())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(localGatewayRouteTableArn(), other.localGatewayRouteTableArn())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(state(), other.state())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                .add("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId",
                        localGatewayRouteTableVirtualInterfaceGroupAssociationId())
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("LocalGatewayId", localGatewayId()).add("LocalGatewayRouteTableId", localGatewayRouteTableId())
                .add("LocalGatewayRouteTableArn", localGatewayRouteTableArn()).add("OwnerId", ownerId()).add("State", state())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVirtualInterfaceGroupAssociationId()));
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "LocalGatewayRouteTableArn":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayRouteTableVirtualInterfaceGroupAssociation, T> g) {
        return obj -> g.apply((LocalGatewayRouteTableVirtualInterfaceGroupAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayRouteTableVirtualInterfaceGroupAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId);

        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
         * </p>
         * 
         * @param localGatewayRouteTableArn
         *        The Amazon Resource Name (ARN) of the local gateway route table for the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableArn(String localGatewayRouteTableArn);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface group association.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the local gateway virtual interface group
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

        private String localGatewayVirtualInterfaceGroupId;

        private String localGatewayId;

        private String localGatewayRouteTableId;

        private String localGatewayRouteTableArn;

        private String ownerId;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayRouteTableVirtualInterfaceGroupAssociation model) {
            localGatewayRouteTableVirtualInterfaceGroupAssociationId(model.localGatewayRouteTableVirtualInterfaceGroupAssociationId);
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            localGatewayId(model.localGatewayId);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            localGatewayRouteTableArn(model.localGatewayRouteTableArn);
            ownerId(model.ownerId);
            state(model.state);
            tags(model.tags);
        }

        public final String getLocalGatewayRouteTableVirtualInterfaceGroupAssociationId() {
            return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        public final void setLocalGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        @Transient
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        @Transient
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayRouteTableArn() {
            return localGatewayRouteTableArn;
        }

        public final void setLocalGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
        }

        @Override
        @Transient
        public final Builder localGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LocalGatewayRouteTableVirtualInterfaceGroupAssociation build() {
            return new LocalGatewayRouteTableVirtualInterfaceGroupAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
