/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class IpamResourceCidrSetCopier {
    static List<IpamResourceCidr> copy(Collection<? extends IpamResourceCidr> ipamResourceCidrSetParam) {
        List<IpamResourceCidr> list;
        if (ipamResourceCidrSetParam == null || ipamResourceCidrSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<IpamResourceCidr> modifiableList = new ArrayList<>();
            ipamResourceCidrSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<IpamResourceCidr> copyFromBuilder(Collection<? extends IpamResourceCidr.Builder> ipamResourceCidrSetParam) {
        List<IpamResourceCidr> list;
        if (ipamResourceCidrSetParam == null || ipamResourceCidrSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<IpamResourceCidr> modifiableList = new ArrayList<>();
            ipamResourceCidrSetParam.forEach(entry -> {
                IpamResourceCidr member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<IpamResourceCidr.Builder> copyToBuilder(Collection<? extends IpamResourceCidr> ipamResourceCidrSetParam) {
        List<IpamResourceCidr.Builder> list;
        if (ipamResourceCidrSetParam == null || ipamResourceCidrSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<IpamResourceCidr.Builder> modifiableList = new ArrayList<>();
            ipamResourceCidrSetParam.forEach(entry -> {
                IpamResourceCidr.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
