/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamResponse extends Ec2Response implements
        ToCopyableBuilder<CreateIpamResponse.Builder, CreateIpamResponse> {
    private static final SdkField<Ipam> IPAM_FIELD = SdkField
            .<Ipam> builder(MarshallingType.SDK_POJO)
            .memberName("Ipam")
            .getter(getter(CreateIpamResponse::ipam))
            .setter(setter(Builder::ipam))
            .constructor(Ipam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipam")
                    .unmarshallLocationName("ipam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_FIELD));

    private final Ipam ipam;

    private CreateIpamResponse(BuilderImpl builder) {
        super(builder);
        this.ipam = builder.ipam;
    }

    /**
     * <p>
     * Information about the IPAM created.
     * </p>
     * 
     * @return Information about the IPAM created.
     */
    public final Ipam ipam() {
        return ipam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamResponse)) {
            return false;
        }
        CreateIpamResponse other = (CreateIpamResponse) obj;
        return Objects.equals(ipam(), other.ipam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamResponse").add("Ipam", ipam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipam":
            return Optional.ofNullable(clazz.cast(ipam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamResponse, T> g) {
        return obj -> g.apply((CreateIpamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpamResponse> {
        /**
         * <p>
         * Information about the IPAM created.
         * </p>
         * 
         * @param ipam
         *        Information about the IPAM created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipam(Ipam ipam);

        /**
         * <p>
         * Information about the IPAM created.
         * </p>
         * This is a convenience that creates an instance of the {@link Ipam.Builder} avoiding the need to create one
         * manually via {@link Ipam#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ipam.Builder#build()} is called immediately and its result is
         * passed to {@link #ipam(Ipam)}.
         * 
         * @param ipam
         *        a consumer that will call methods on {@link Ipam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipam(Ipam)
         */
        default Builder ipam(Consumer<Ipam.Builder> ipam) {
            return ipam(Ipam.builder().applyMutation(ipam).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Ipam ipam;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamResponse model) {
            super(model);
            ipam(model.ipam);
        }

        public final Ipam.Builder getIpam() {
            return ipam != null ? ipam.toBuilder() : null;
        }

        public final void setIpam(Ipam.BuilderImpl ipam) {
            this.ipam = ipam != null ? ipam.build() : null;
        }

        @Override
        @Transient
        public final Builder ipam(Ipam ipam) {
            this.ipam = ipam;
            return this;
        }

        @Override
        public CreateIpamResponse build() {
            return new CreateIpamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
