/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamRequest extends Ec2Request implements
        ToCopyableBuilder<CreateIpamRequest.Builder, CreateIpamRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateIpamRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<AddIpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField
            .<List<AddIpamOperatingRegion>> builder(MarshallingType.LIST)
            .memberName("OperatingRegions")
            .getter(getter(CreateIpamRequest::operatingRegions))
            .setter(setter(Builder::operatingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegion")
                    .unmarshallLocationName("OperatingRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddIpamOperatingRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddIpamOperatingRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateIpamRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIpamRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            OPERATING_REGIONS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private final String description;

    private final List<AddIpamOperatingRegion> operatingRegions;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private CreateIpamRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A description for the IPAM.
     * </p>
     * 
     * @return A description for the IPAM.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperatingRegions() {
        return operatingRegions != null && !(operatingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed
     * to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you
     * select as operating Regions.
     * </p>
     * <p>
     * For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a>
     * in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingRegions} method.
     * </p>
     * 
     * @return The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is
     *         allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
     *         Regions you select as operating Regions.</p>
     *         <p>
     *         For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an
     *         IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     */
    public final List<AddIpamOperatingRegion> operatingRegions() {
        return operatingRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value
     * as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the
     * value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the
     * filter value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the
     *         tag value as the filter value. For example, to find all resources that have a tag with the key
     *         <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     *         and <code>TeamA</code> for the filter value.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingRegions() ? operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamRequest)) {
            return false;
        }
        CreateIpamRequest other = (CreateIpamRequest) obj;
        return Objects.equals(description(), other.description()) && hasOperatingRegions() == other.hasOperatingRegions()
                && Objects.equals(operatingRegions(), other.operatingRegions())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamRequest").add("Description", description())
                .add("OperatingRegions", hasOperatingRegions() ? operatingRegions() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OperatingRegions":
            return Optional.ofNullable(clazz.cast(operatingRegions()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamRequest, T> g) {
        return obj -> g.apply((CreateIpamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpamRequest> {
        /**
         * <p>
         * A description for the IPAM.
         * </p>
         * 
         * @param description
         *        A description for the IPAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is
         * allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param operatingRegions
         *        The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM
         *        is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         *        Services Regions you select as operating Regions.</p>
         *        <p>
         *        For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create
         *        an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions);

        /**
         * <p>
         * The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is
         * allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * 
         * @param operatingRegions
         *        The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM
         *        is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web
         *        Services Regions you select as operating Regions.</p>
         *        <p>
         *        For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create
         *        an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingRegions(AddIpamOperatingRegion... operatingRegions);

        /**
         * <p>
         * The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is
         * allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services
         * Regions you select as operating Regions.
         * </p>
         * <p>
         * For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an
         * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddIpamOperatingRegion>.Builder} avoiding
         * the need to create one manually via {@link List<AddIpamOperatingRegion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddIpamOperatingRegion>.Builder#build()} is called
         * immediately and its result is passed to {@link #operatingRegions(List<AddIpamOperatingRegion>)}.
         * 
         * @param operatingRegions
         *        a consumer that will call methods on {@link List<AddIpamOperatingRegion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingRegions(List<AddIpamOperatingRegion>)
         */
        Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder>... operatingRegions);

        /**
         * <p>
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag
         * value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code>
         * and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code>
         * for the filter value.
         * </p>
         * 
         * @param tagSpecifications
         *        The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and
         *        the tag value as the filter value. For example, to find all resources that have a tag with the key
         *        <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter
         *        name and <code>TeamA</code> for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag
         * value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code>
         * and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code>
         * for the filter value.
         * </p>
         * 
         * @param tagSpecifications
         *        The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and
         *        the tag value as the filter value. For example, to find all resources that have a tag with the key
         *        <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter
         *        name and <code>TeamA</code> for the filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag
         * value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code>
         * and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code>
         * for the filter value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String description;

        private List<AddIpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamRequest model) {
            super(model);
            description(model.description);
            operatingRegions(model.operatingRegions);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        @Transient
        public final Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operatingRegions(AddIpamOperatingRegion... operatingRegions) {
            operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder>... operatingRegions) {
            operatingRegions(Stream.of(operatingRegions).map(c -> AddIpamOperatingRegion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamRequest build() {
            return new CreateIpamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
