/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCarrierGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateCarrierGatewayResponse.Builder, CreateCarrierGatewayResponse> {
    private static final SdkField<CarrierGateway> CARRIER_GATEWAY_FIELD = SdkField
            .<CarrierGateway> builder(MarshallingType.SDK_POJO)
            .memberName("CarrierGateway")
            .getter(getter(CreateCarrierGatewayResponse::carrierGateway))
            .setter(setter(Builder::carrierGateway))
            .constructor(CarrierGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGateway")
                    .unmarshallLocationName("carrierGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_GATEWAY_FIELD));

    private final CarrierGateway carrierGateway;

    private CreateCarrierGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.carrierGateway = builder.carrierGateway;
    }

    /**
     * <p>
     * Information about the carrier gateway.
     * </p>
     * 
     * @return Information about the carrier gateway.
     */
    public final CarrierGateway carrierGateway() {
        return carrierGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(carrierGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCarrierGatewayResponse)) {
            return false;
        }
        CreateCarrierGatewayResponse other = (CreateCarrierGatewayResponse) obj;
        return Objects.equals(carrierGateway(), other.carrierGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCarrierGatewayResponse").add("CarrierGateway", carrierGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CarrierGateway":
            return Optional.ofNullable(clazz.cast(carrierGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCarrierGatewayResponse, T> g) {
        return obj -> g.apply((CreateCarrierGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateCarrierGatewayResponse> {
        /**
         * <p>
         * Information about the carrier gateway.
         * </p>
         * 
         * @param carrierGateway
         *        Information about the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGateway(CarrierGateway carrierGateway);

        /**
         * <p>
         * Information about the carrier gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link CarrierGateway.Builder} avoiding the need to
         * create one manually via {@link CarrierGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link CarrierGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #carrierGateway(CarrierGateway)}.
         * 
         * @param carrierGateway
         *        a consumer that will call methods on {@link CarrierGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #carrierGateway(CarrierGateway)
         */
        default Builder carrierGateway(Consumer<CarrierGateway.Builder> carrierGateway) {
            return carrierGateway(CarrierGateway.builder().applyMutation(carrierGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CarrierGateway carrierGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCarrierGatewayResponse model) {
            super(model);
            carrierGateway(model.carrierGateway);
        }

        public final CarrierGateway.Builder getCarrierGateway() {
            return carrierGateway != null ? carrierGateway.toBuilder() : null;
        }

        public final void setCarrierGateway(CarrierGateway.BuilderImpl carrierGateway) {
            this.carrierGateway = carrierGateway != null ? carrierGateway.build() : null;
        }

        @Override
        @Transient
        public final Builder carrierGateway(CarrierGateway carrierGateway) {
            this.carrierGateway = carrierGateway;
            return this;
        }

        @Override
        public CreateCarrierGatewayResponse build() {
            return new CreateCarrierGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
