/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledInstanceAvailabilityRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::filters)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<SlotDateTimeRangeRequest> FIRST_SLOT_START_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirstSlotStartTimeRange").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::firstSlotStartTimeRange)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::firstSlotStartTimeRange)).constructor(SlotDateTimeRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSlotStartTimeRange").unmarshallLocationName("FirstSlotStartTimeRange").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::maxResults)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<Integer> MAX_SLOT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSlotDurationInHours").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::maxSlotDurationInHours)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::maxSlotDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSlotDurationInHours").unmarshallLocationName("MaxSlotDurationInHours").build()}).build();
    private static final SdkField<Integer> MIN_SLOT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSlotDurationInHours").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::minSlotDurationInHours)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::minSlotDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSlotDurationInHours").unmarshallLocationName("MinSlotDurationInHours").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::nextToken)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<ScheduledInstanceRecurrenceRequest> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(DescribeScheduledInstanceAvailabilityRequest.getter(DescribeScheduledInstanceAvailabilityRequest::recurrence)).setter(DescribeScheduledInstanceAvailabilityRequest.setter(Builder::recurrence)).constructor(ScheduledInstanceRecurrenceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").unmarshallLocationName("Recurrence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, FIRST_SLOT_START_TIME_RANGE_FIELD, MAX_RESULTS_FIELD, MAX_SLOT_DURATION_IN_HOURS_FIELD, MIN_SLOT_DURATION_IN_HOURS_FIELD, NEXT_TOKEN_FIELD, RECURRENCE_FIELD));
    private final List<Filter> filters;
    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;
    private final Integer maxResults;
    private final Integer maxSlotDurationInHours;
    private final Integer minSlotDurationInHours;
    private final String nextToken;
    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return this.firstSlotStartTimeRange;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Integer maxSlotDurationInHours() {
        return this.maxSlotDurationInHours;
    }

    public final Integer minSlotDurationInHours() {
        return this.minSlotDurationInHours;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ScheduledInstanceRecurrenceRequest recurrence() {
        return this.recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSlotStartTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.firstSlotStartTimeRange(), other.firstSlotStartTimeRange()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.maxSlotDurationInHours(), other.maxSlotDurationInHours()) && Objects.equals(this.minSlotDurationInHours(), other.minSlotDurationInHours()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.recurrence(), other.recurrence());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledInstanceAvailabilityRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("FirstSlotStartTimeRange", (Object)this.firstSlotStartTimeRange()).add("MaxResults", (Object)this.maxResults()).add("MaxSlotDurationInHours", (Object)this.maxSlotDurationInHours()).add("MinSlotDurationInHours", (Object)this.minSlotDurationInHours()).add("NextToken", (Object)this.nextToken()).add("Recurrence", (Object)this.recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "FirstSlotStartTimeRange": {
                return Optional.ofNullable(clazz.cast(this.firstSlotStartTimeRange()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "MaxSlotDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.maxSlotDurationInHours()));
            }
            case "MinSlotDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.minSlotDurationInHours()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledInstanceAvailabilityRequest, T> g) {
        return obj -> g.apply((DescribeScheduledInstanceAvailabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private SlotDateTimeRangeRequest firstSlotStartTimeRange;
        private Integer maxResults;
        private Integer maxSlotDurationInHours;
        private Integer minSlotDurationInHours;
        private String nextToken;
        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            super(model);
            this.filters(model.filters);
            this.firstSlotStartTimeRange(model.firstSlotStartTimeRange);
            this.maxResults(model.maxResults);
            this.maxSlotDurationInHours(model.maxSlotDurationInHours);
            this.minSlotDurationInHours(model.minSlotDurationInHours);
            this.nextToken(model.nextToken);
            this.recurrence(model.recurrence);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final SlotDateTimeRangeRequest.Builder getFirstSlotStartTimeRange() {
            return this.firstSlotStartTimeRange != null ? this.firstSlotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest.BuilderImpl firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange != null ? firstSlotStartTimeRange.build() : null;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return this.maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return this.minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest var1);

        default public Builder firstSlotStartTimeRange(Consumer<SlotDateTimeRangeRequest.Builder> firstSlotStartTimeRange) {
            return this.firstSlotStartTimeRange((SlotDateTimeRangeRequest)((SlotDateTimeRangeRequest.Builder)SlotDateTimeRangeRequest.builder().applyMutation(firstSlotStartTimeRange)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder maxSlotDurationInHours(Integer var1);

        public Builder minSlotDurationInHours(Integer var1);

        public Builder nextToken(String var1);

        public Builder recurrence(ScheduledInstanceRecurrenceRequest var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrenceRequest.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrenceRequest)((ScheduledInstanceRecurrenceRequest.Builder)ScheduledInstanceRecurrenceRequest.builder().applyMutation(recurrence)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

