/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Region;
import software.amazon.awssdk.services.ec2.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeRegionsResponse> {
    private static final SdkField<List<Region>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(DescribeRegionsResponse.getter(DescribeRegionsResponse::regions)).setter(DescribeRegionsResponse.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionInfo").unmarshallLocationName("regionInfo").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD));
    private final List<Region> regions;

    private DescribeRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.regions = builder.regions;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsResponse)) {
            return false;
        }
        DescribeRegionsResponse other = (DescribeRegionsResponse)((Object)obj);
        return this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegionsResponse").add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegionsResponse, T> g) {
        return obj -> g.apply((DescribeRegionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Region> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsResponse model) {
            super(model);
            this.regions(model.regions);
        }

        public final List<Region.Builder> getRegions() {
            List<Region.Builder> result = RegionListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder> ... regions) {
            this.regions(Stream.of(regions).map(c -> (Region)((Region.Builder)Region.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionListCopier.copyFromBuilder(regions);
        }

        @Override
        public DescribeRegionsResponse build() {
            return new DescribeRegionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegionsResponse> {
        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);

        public Builder regions(Consumer<Region.Builder> ... var1);
    }
}

